/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.statistics.api.reader;

import com.sap.jdsr.passport.DSRPassport;
import com.sap.jdsr.passport.EncodeDecode;
import com.sap.js.statistics.api.reader.DsrReaderException;
import com.sap.js.statistics.api.writer.DSRConstants;
import com.sap.js.statistics.api.writer.DSRConvert;
import com.sap.js.statistics.api.writer.DSRExternalRecord;
import com.sap.js.statistics.api.writer.DSRHTTPRecord;
import com.sap.js.statistics.api.writer.DSRKeyValueField;
import com.sap.js.statistics.api.writer.DSRMainRecord;
import com.sap.js.statistics.api.writer.DSRRecord;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class DSRRecordsReader {
    private static final int BUFFER_SIZE = 10;
    private BufferedInputStream in = null;
    private boolean mainIdAlreadyRead;
    private long currentFileReadPosition;
    private byte[] buffer = new byte[1024];
    private String returnedString = null;
    private byte[] byteArray = null;
    private final long endTime;
    private static byte[] mainId = new byte[4];

    static {
        DSRConvert.int2FourByte(123454321, mainId, 0);
    }

    public DSRRecordsReader(BufferedInputStream in, long pos, long endTime) throws IOException {
        this.in = in;
        this.mainIdAlreadyRead = false;
        this.endTime = endTime;
        this.currentFileReadPosition = pos;
    }

    public long getCurrentFileReadPosition() {
        return this.currentFileReadPosition;
    }

    public DSRRecord readNextRecord() throws DsrReaderException, IOException {
        byte[] b = new byte[4];
        DSRRecord r = new DSRRecord();
        if (!this.syncToNewRecordSet()) {
            return null;
        }
        DSRMainRecord main = this.readMain();
        if (main == null) {
            return null;
        }
        r.setMainRecord(main);
        boolean call1Found = false;
        DSRExternalRecord extRec = null;
        while (this.nextBytes(b, 4)) {
            int id = DSRConvert.fourByte2Int(b, 0);
            if (123454321 == id) {
                this.mainIdAlreadyRead = true;
                break;
            }
            if (567898765 == id) {
                call1Found = false;
                if (this.readPassport(r)) continue;
                return null;
            }
            if (345676543 == id) {
                call1Found = false;
                extRec = this.readCall1();
                if (extRec == null) {
                    return null;
                }
                call1Found = true;
                r.addSubRecord(extRec);
                continue;
            }
            if (901232109 == id) {
                if (call1Found && extRec != null) {
                    this.readExternalCounters(extRec);
                    call1Found = false;
                    continue;
                }
                this.skipRecord();
                continue;
            }
            if (123456789 == id) {
                call1Found = false;
                DSRKeyValueField rec = this.readKeyValueRecord();
                if (rec == null || r.getMain() == null) continue;
                if (Arrays.equals(rec.getKey(), DSRConstants.keyValueRecord_sessionSizeKey)) {
                    r.getMain().setSessionSize(rec.getIntValue());
                    continue;
                }
                if (Arrays.equals(rec.getKey(), DSRConstants.keyValueRecord_dbCallsKey)) {
                    r.getMain().setDbCalls(rec.getIntValue());
                    continue;
                }
                if (!Arrays.equals(rec.getKey(), DSRConstants.keyValueRecord_dbIOKey)) continue;
                r.getMain().setDbIO(rec.getLongValue());
                continue;
            }
            if (678909876 == id) {
                call1Found = false;
                if (this.readHttpRecord(r)) continue;
                return null;
            }
            if (456787654 == id) {
                call1Found = false;
                this.skipRecord();
                continue;
            }
            call1Found = false;
            this.skipRecord();
        }
        return r;
    }

    private void skipRecord() throws DsrReaderException, IOException {
        this.buffer = new byte[10];
        if (!this.nextBytes(this.buffer, 2)) {
            return;
        }
        int len = DSRConvert.twoByte2Int(this.buffer, 0) - 6;
        if (len < 0) {
            this.throwReadFailed("skipRecord", 0);
        }
        if (len == 0) {
            return;
        }
        if (10 < len) {
            this.buffer = new byte[len];
        }
        if (!this.nextBytes(this.buffer, len)) {
            return;
        }
    }

    private boolean syncToNewRecordSet() throws IOException {
        int b;
        if (this.mainIdAlreadyRead) {
            this.mainIdAlreadyRead = false;
            return true;
        }
        int count = 0;
        while (-1 != (b = this.nextByte())) {
            if ((byte)b == mainId[count]) {
                if (4 != ++count) continue;
                return true;
            }
            count = count != 0 && (byte)b == mainId[0] ? 1 : 0;
        }
        return false;
    }

    private DSRMainRecord readMain() throws DsrReaderException, IOException {
        this.buffer = new byte[10];
        if (!this.nextBytes(this.buffer, 2)) {
            return null;
        }
        int len = DSRConvert.twoByte2Int(this.buffer, 0) - 6;
        if (10 > len) {
            this.throwReadFailed("readMain", 0);
        }
        if (10 < len) {
            this.buffer = new byte[len];
        }
        if (!this.nextBytes(this.buffer, len)) {
            return null;
        }
        long endTime = DSRConvert.eightByte2Long(this.buffer, 0);
        if (0L > endTime) {
            this.throwReadFailed("readMain", 0);
        }
        endTime *= 1000L;
        if (this.endTime < (endTime += (long)DSRConvert.twoByte2Int(this.buffer, 8))) {
            return null;
        }
        int index = 10;
        DSRMainRecord mainRec = this.readMainFields(this.buffer, index, len);
        return mainRec;
    }

    private boolean readHttpRecord(DSRRecord r) throws DsrReaderException, IOException {
        this.buffer = new byte[10];
        if (!this.nextBytes(this.buffer, 2)) {
            return false;
        }
        int len = DSRConvert.twoByte2Int(this.buffer, 0) - 6;
        if (len < 0) {
            this.throwReadFailed("readXiRecord", 0);
        }
        if (len == 0) {
            return true;
        }
        if (10 < len) {
            this.buffer = new byte[len];
        }
        if (!this.nextBytes(this.buffer, len)) {
            return false;
        }
        DSRHTTPRecord httpRec = this.readHttpFields(this.buffer, len);
        if (httpRec != null) {
            r.setHttpRecord(httpRec);
            return true;
        }
        return false;
    }

    private boolean readPassport(DSRRecord r) throws DsrReaderException, IOException {
        this.buffer = new byte[10];
        if (!this.nextBytes(this.buffer, 2)) {
            return false;
        }
        int len = DSRConvert.twoByte2Int(this.buffer, 0) - 6;
        if (len < 0) {
            this.throwReadFailed("readPassport", 0);
        }
        if (len == 0) {
            return true;
        }
        if (10 < len) {
            this.buffer = new byte[len];
        }
        if (!this.nextBytes(this.buffer, len)) {
            return false;
        }
        DSRPassport pass = this.readPassportFields(this.buffer, len);
        r.setPassport(pass);
        return true;
    }

    private boolean readExternalCounters(DSRExternalRecord subrec) throws DsrReaderException, IOException {
        this.buffer = new byte[10];
        if (!this.nextBytes(this.buffer, 2)) {
            return false;
        }
        int len = DSRConvert.twoByte2Int(this.buffer, 0) - 6;
        if (len < 0) {
            this.throwReadFailed("readExternalCounters", 0);
        }
        if (len == 0) {
            return false;
        }
        if (10 < len) {
            this.buffer = new byte[len];
        }
        if (!this.nextBytes(this.buffer, len)) {
            return false;
        }
        this.readExternalCountersFields(this.buffer, len, subrec);
        return true;
    }

    private DSRKeyValueField readKeyValueRecord() throws DsrReaderException, IOException {
        this.buffer = new byte[10];
        if (!this.nextBytes(this.buffer, 2)) {
            return null;
        }
        int len = DSRConvert.twoByte2Int(this.buffer, 0) - 6;
        if (len < 0) {
            this.throwReadFailed("readKeyValueRecord", 0);
        }
        if (len == 0) {
            return null;
        }
        if (10 < len) {
            this.buffer = new byte[len];
        }
        if (!this.nextBytes(this.buffer, len)) {
            return null;
        }
        DSRKeyValueField field = this.readKeyValueFields(this.buffer, len);
        return field;
    }

    private DSRExternalRecord readCall1() throws DsrReaderException, IOException {
        this.buffer = new byte[10];
        if (!this.nextBytes(this.buffer, 2)) {
            return null;
        }
        int len = DSRConvert.twoByte2Int(this.buffer, 0) - 6;
        if (len < 0) {
            this.throwReadFailed("readCall1", 0);
        }
        if (len == 0) {
            return null;
        }
        if (10 < len) {
            this.buffer = new byte[len];
        }
        if (!this.nextBytes(this.buffer, len)) {
            return null;
        }
        DSRExternalRecord subRec = this.readExternalFields(this.buffer, len);
        return subRec;
    }

    private boolean nextBytes(byte[] b, int numberToRead) throws IOException {
        int i = 0;
        while (i < numberToRead) {
            int r = this.nextByte();
            if (-1 == r) {
                return false;
            }
            b[i] = (byte)r;
            ++i;
        }
        return true;
    }

    private int nextByte() throws IOException {
        int r = this.in.read();
        if (-1 != r) {
            ++this.currentFileReadPosition;
        }
        return r;
    }

    private void throwReadFailed(String where, int index) throws DsrReaderException {
        throw new DsrReaderException("DSRRecordsReader." + where + "(" + index + "): " + "failed to read 2 bytes from " + " at position: " + this.currentFileReadPosition);
    }

    private DSRMainRecord readMainFields(byte[] buf, int start, int len) throws DsrReaderException {
        int index = start;
        DSRMainRecord mainRec = new DSRMainRecord();
        while (index < len) {
            index += this.readMainField(index, mainRec);
        }
        return mainRec;
    }

    private DSRKeyValueField readKeyValueFields(byte[] buf, int len) throws DsrReaderException {
        byte typeId;
        int index = 0;
        if (len < 5) {
            return null;
        }
        byte fieldId = this.buffer[index];
        if (fieldId != 100) {
            throw new DsrReaderException("DSRreader.readKeyValueField(): unexpected field type: " + this.buffer[index] + ". expected: " + 100);
        }
        if ((typeId = this.buffer[++index]) != 100) {
            throw new DsrReaderException("DSRreader.readKeyValueField(): unexpected field type: " + this.buffer[index] + ". expected: " + 100);
        }
        byte[] key = new byte[4];
        System.arraycopy(this.buffer, ++index, key, 0, 4);
        index += 4;
        byte id = this.buffer[++index];
        if (id == 5) {
            byte cfr_ignored_0 = this.buffer[index];
        } else {
            if (id == 0) {
                int v32 = this.readInt32Field(index);
                return new DSRKeyValueField(key, v32, 0);
            }
            if (id == 1) {
                long v64 = this.readInt64Field(index);
                return new DSRKeyValueField(key, v64, 1);
            }
            if (id == 3) {
                this.readByteArray(index);
            } else {
                if (id == 2) {
                    this.readStringField(index);
                    return new DSRKeyValueField(key, this.returnedString, 2);
                }
                if (id == 4) {
                    this.readStringUTF8Field(index);
                    return new DSRKeyValueField(key, this.returnedString, 4);
                }
            }
        }
        ++index;
        return null;
    }

    private DSRHTTPRecord readHttpFields(byte[] buf, int len) throws DsrReaderException {
        DSRHTTPRecord rec = null;
        int index = 0;
        while (index < this.buffer.length) {
            int v32;
            byte id = this.buffer[index];
            if (id == 68) {
                index = index++ + this.readStringField(index);
                if (this.returnedString != null) {
                    if (rec == null) {
                        rec = new DSRHTTPRecord();
                    }
                    rec.setHttpRequestId(this.returnedString);
                }
            } else if (id == 60) {
                index = index++ + this.readStringField(index);
                if (this.returnedString != null) {
                    if (rec == null) {
                        rec = new DSRHTTPRecord();
                    }
                    rec.setHost(this.returnedString);
                }
            } else if (id == 69) {
                index = index++ + this.readStringField(index);
                if (this.returnedString != null) {
                    if (rec == null) {
                        rec = new DSRHTTPRecord();
                    }
                    rec.setClientIp(this.returnedString);
                }
            } else if (id == 70) {
                index = index++ + this.readStringField(index);
                if (this.returnedString != null) {
                    if (rec == null) {
                        rec = new DSRHTTPRecord();
                    }
                    rec.setRequestLine(this.returnedString);
                }
            } else if (id == 72) {
                index = index++ + this.readStringField(index);
                if (this.returnedString != null) {
                    if (rec == null) {
                        rec = new DSRHTTPRecord();
                    }
                    rec.setResponsePhase(this.returnedString);
                }
            } else if (id == 61) {
                index = index++ + this.readStringField(index);
                if (this.returnedString != null) {
                    if (rec == null) {
                        rec = new DSRHTTPRecord();
                    }
                    rec.setScheme(this.returnedString);
                }
            } else if (id == 63) {
                if ((v32 = this.readInt32Field(++index)) != 0) {
                    if (rec == null) {
                        rec = new DSRHTTPRecord();
                    }
                    rec.setPort(v32);
                }
                index += 4;
            } else if (id == 73) {
                if ((v32 = this.readInt32Field(++index)) != 0) {
                    if (rec == null) {
                        rec = new DSRHTTPRecord();
                    }
                    rec.setRequestLength(v32);
                }
                index += 4;
            } else if (id == 74) {
                if ((v32 = this.readInt32Field(++index)) != 0) {
                    if (rec == null) {
                        rec = new DSRHTTPRecord();
                    }
                    rec.setResponseLength(v32);
                }
                index += 4;
            } else if (id == 71) {
                if ((v32 = this.readInt32Field(++index)) != 0) {
                    if (rec == null) {
                        rec = new DSRHTTPRecord();
                    }
                    rec.setResponseCode(v32);
                }
                index += 4;
            } else {
                return rec;
            }
            ++index;
        }
        return rec;
    }

    private DSRPassport readPassportFields(byte[] buf, int len) throws DsrReaderException {
        int index = 0;
        byte id = this.buffer[index];
        ++index;
        if (id == 36) {
            index += this.readByteArray(index);
            DSRPassport passRec = EncodeDecode.decodeBytePassport((byte[])this.byteArray);
            return passRec;
        }
        return null;
    }

    private void readExternalCountersFields(byte[] buf, int len, DSRExternalRecord subRec) throws DsrReaderException {
        int index = 0;
        while (index < len) {
            byte id = this.buffer[index];
            ++index;
            if (34 == id) {
                int v32 = this.readInt32Field(index);
                subRec.setConnectionCounter(v32);
                index += 5;
                continue;
            }
            if (35 == id) {
                index += this.readByteArray(index);
                subRec.setConnectionId(this.byteArray);
                continue;
            }
            index = this.skipField(index);
        }
    }

    private DSRExternalRecord readExternalFields(byte[] buf, int len) throws DsrReaderException {
        int index = 0;
        DSRExternalRecord subRec = new DSRExternalRecord();
        while (index < len) {
            index += this.readExternalSubField(index, subRec);
        }
        return subRec;
    }

    private int skipField(int index) throws DsrReaderException {
        if (2 == this.buffer[index]) {
            index += this.readStringField(index);
        } else if (4 == this.buffer[index]) {
            index += this.readStringField(index);
        } else if (3 == this.buffer[index]) {
            index += this.readByteArray(index);
        } else if (1 == this.buffer[index]) {
            index += 9;
        } else if (this.buffer[index] == 0) {
            index += 5;
        } else if (5 == this.buffer[index]) {
            ++index;
        } else {
            throw new DsrReaderException("Unknown field Id unexpected field type: " + this.buffer[index]);
        }
        return index;
    }

    private int readExternalSubField(int bufferIndex, DSRExternalRecord subRecExternal) throws DsrReaderException {
        int index = bufferIndex;
        byte id = this.buffer[index];
        ++index;
        if (16 == id) {
            long v64 = this.readInt64Field(index);
            subRecExternal.setCallTime(v64);
            index += 9;
        } else if (23 == id) {
            long v64 = this.readInt64Field(index);
            subRecExternal.setSentBytes(v64);
            index += 9;
        } else if (21 == id) {
            long v64 = this.readInt64Field(index);
            subRecExternal.setReceivedBytes(v64);
            index += 9;
        } else if (18 == id) {
            index += this.readStringField(index);
            subRecExternal.setTypeString(this.returnedString);
        } else if (34 == id) {
            int v32 = this.readInt32Field(index);
            subRecExternal.setConnectionCounter(v32);
            index += 5;
        } else if (17 == id) {
            index += this.readStringField(index);
            subRecExternal.setSystemId(this.returnedString);
        } else if (19 == id) {
            index += this.readStringField(index);
            subRecExternal.setDestination(this.returnedString);
        } else if (35 == id) {
            index += this.readByteArray(index);
            subRecExternal.setConnectionId(this.byteArray);
        } else if (2 == id) {
            index += this.readStringField(index);
            subRecExternal.setAddInfo(this.returnedString);
        } else {
            index = this.skipField(index);
        }
        return index - bufferIndex;
    }

    private int readMainField(int bufferIndex, DSRMainRecord mainRec) throws DsrReaderException {
        int index = bufferIndex;
        byte id = this.buffer[index];
        ++index;
        if (12 == id) {
            long v64 = this.readInt64Field(index);
            mainRec.setStartTime(v64 * 1000L);
            index += 9;
        } else if (28 == id) {
            int v32 = this.readInt32Field(index);
            long v64 = mainRec.getStartTime();
            mainRec.setStartTime(v64 += (long)v32);
            index += 5;
        } else if (11 == id) {
            int v32 = this.readInt32Field(index);
            mainRec.setServiceType(v32);
            index += 5;
        } else if (1 == id) {
            int v32 = this.readInt32Field(index);
            mainRec.setActionType(v32);
            index += 5;
        } else if (3 == id) {
            long v64 = this.readInt64Field(index);
            mainRec.setCpuTime(v64);
            index += 9;
        } else if (15 == id) {
            long v64 = this.readInt64Field(index);
            mainRec.setExtTime(v64);
            index += 9;
        } else if (10 == id) {
            long v64 = this.readInt64Field(index);
            mainRec.setRespTime(v64);
            index += 9;
        } else if (7 == id) {
            long v64 = this.readInt64Field(index);
            mainRec.setAllocMem(v64);
            index += 9;
        } else if (31 == id) {
            long v64 = this.readInt64Field(index);
            mainRec.setDbTime(v64);
            index += 9;
        } else if (23 == id) {
            long v64 = this.readInt64Field(index);
            mainRec.setSentBytes(v64);
            index += 9;
        } else if (21 == id) {
            long v64 = this.readInt64Field(index);
            mainRec.setReceivedBytes(v64);
            index += 9;
        } else if (13 == id) {
            index += this.readStringField(index);
            mainRec.setTransId(this.returnedString);
        } else if (id == 0) {
            index += this.readStringField(index);
            mainRec.setAction(this.returnedString);
        } else if (14 == id) {
            index += this.readStringField(index);
            mainRec.setUserId(this.returnedString);
        } else if (2 == id) {
            index += this.readStringField(index);
            mainRec.setAddInfo(this.returnedString);
        } else {
            index = this.skipField(index);
        }
        return index - bufferIndex;
    }

    private int readStringField(int idx) throws DsrReaderException {
        if (2 != this.buffer[idx]) {
            throw new DsrReaderException("DsrStatisticDataReader.readStringField(): unexpected field type: " + this.buffer[idx] + ". expected: " + 2);
        }
        int length = DSRConvert.twoByte2Int(this.buffer, idx + 1);
        try {
            this.returnedString = new String(this.buffer, idx + 3, length, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new DsrReaderException("Cannot read string", e);
        }
        return length + 3;
    }

    private int readStringUTF8Field(int idx) throws DsrReaderException {
        if (4 != this.buffer[idx]) {
            throw new DsrReaderException("DsrStatisticDataReader.readStringUTF8Field(): unexpected field type: " + this.buffer[idx] + ". expected: " + 4);
        }
        int length = DSRConvert.twoByte2Int(this.buffer, idx + 1);
        try {
            this.returnedString = new String(this.buffer, idx + 3, length, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new DsrReaderException("readStringUTF8Field: UTF-8 is not supported", e);
        }
        return length + 3;
    }

    public int readByteArray(int idx) throws DsrReaderException {
        if (3 != this.buffer[idx]) {
            throw new DsrReaderException("DsrStatisticDataReader.readStringField(): unexpected field type: " + this.buffer[idx] + ". expected: " + 3);
        }
        int length = DSRConvert.twoByte2Int(this.buffer, idx + 1);
        this.byteArray = new byte[length];
        System.arraycopy(this.buffer, idx + 3, this.byteArray, 0, length);
        return length + 3;
    }

    private int readInt32Field(int bufferIndex) throws DsrReaderException {
        if (this.buffer[bufferIndex] != 0) {
            throw new DsrReaderException("DsrStatisticDataReader.readInt32Field(): unexpected field type: " + this.buffer[bufferIndex] + ". expected: " + 0);
        }
        return DSRConvert.fourByte2Int(this.buffer, bufferIndex + 1);
    }

    private long readInt64Field(int bufferIndex) throws DsrReaderException {
        if (1 != this.buffer[bufferIndex]) {
            throw new DsrReaderException("DsrStatisticDataReader.readInt64Field(): unexpected field type: " + this.buffer[bufferIndex] + ". expected: " + 1);
        }
        return DSRConvert.eightByte2Long(this.buffer, bufferIndex + 1);
    }
}

