/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.statistics.api.reader;

import com.sap.js.statistics.api.reader.DsrReaderException;
import com.sap.js.statistics.api.reader.DsrStatFileNameFilter;
import com.sap.js.statistics.api.reader.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.Calendar;

public class DsrIndexReader {
    private final long[] timeIndex = new long[3600];
    private String[] statFileList;
    private final long startTime;

    public DsrIndexReader(String[] statFileList, long startTime) {
        if (statFileList != null) {
            this.statFileList = new String[statFileList.length];
            int i = 0;
            while (i < statFileList.length) {
                this.statFileList[i] = statFileList[i];
                ++i;
            }
        }
        this.startTime = startTime;
    }

    public long getReadPositionFromIndex() throws DsrReaderException {
        long ft = DsrStatFileNameFilter.getTimestampFromFile(this.statFileList[0]);
        long t = this.startTime - ft;
        if (t > 3599999L) {
            return -1L;
        }
        if (0L > t) {
            return 0L;
        }
        this.readTimeIndex();
        Calendar cal = Calendar.getInstance(Utils.timezone);
        cal.clear();
        cal.setTimeInMillis(this.startTime);
        int i = cal.get(12) * 60 + cal.get(13);
        while (i < 3600) {
            if (0L <= this.timeIndex[i]) break;
            ++i;
        }
        if (3600 <= i) {
            return -1L;
        }
        return this.timeIndex[i];
    }

    private void readTimeIndex() throws DsrReaderException {
        StringBuffer sb = new StringBuffer();
        sb.append(this.statFileList[0]);
        int l = sb.length();
        sb.delete(l - ".txt".length(), l);
        sb.append(".six");
        String sixName = sb.toString();
        File sixFile = null;
        sixFile = new File(sixName);
        if (!sixFile.exists()) {
            throw new DsrReaderException("DsrStatisticDataReader.readTimeIndex(): six file does not exist: " + sixName);
        }
        if (!sixFile.canRead()) {
            throw new DsrReaderException("DsrStatisticDataReader.readTimeIndex(): can't read six file: " + sixName);
        }
        FileInputStream is = null;
        InputStreamReader fr = null;
        BufferedReader br = null;
        try {
            StreamTokenizer st;
            try {
                is = new FileInputStream(sixFile);
                fr = new InputStreamReader((InputStream)is, "UTF-8");
                br = new BufferedReader(fr);
                st = new StreamTokenizer(br);
                st.wordChars(58, 122);
                st.eolIsSignificant(true);
            }
            catch (Exception e) {
                throw new DsrReaderException("DsrStatisticDataReader.readTimeIndex(): can't read six file: " + sixName + "caught: " + e.getClass().getName() + e.getMessage(), e);
            }
            int t = this.getNextToken(st);
            if (-3 != t) {
                this.makeSixParseErrorMessage(st, sixName, "<secondindex>");
            }
            if (st.sval.compareToIgnoreCase("<secondindex>") != 0) {
                this.makeSixParseErrorMessage(st, sixName, "<secondindex>");
            }
            if (10 != (t = this.getNextToken(st))) {
                this.makeSixParseErrorMessage(st, sixName, "NEWLINE");
            }
            int i = 0;
            while (i < 3600) {
                t = this.getNextToken(st);
                if (-2 != t) {
                    this.makeSixParseErrorMessage(st, sixName, "NUMBER");
                }
                if ((int)st.nval != i) {
                    this.makeSixParseErrorMessage(st, sixName, new Integer(i).toString());
                }
                if (-3 != (t = this.getNextToken(st))) {
                    this.makeSixParseErrorMessage(st, sixName, "NUMBER");
                }
                if (st.sval.compareTo(":") != 0) {
                    this.makeSixParseErrorMessage(st, sixName, ":");
                }
                if (-2 != (t = this.getNextToken(st))) {
                    this.makeSixParseErrorMessage(st, sixName, "NUMBER");
                }
                this.timeIndex[i] = (long)st.nval;
                t = this.getNextToken(st);
                if (-3 != t) {
                    this.makeSixParseErrorMessage(st, sixName, ";");
                }
                if (st.sval.compareTo(";") != 0) {
                    this.makeSixParseErrorMessage(st, sixName, ";");
                }
                if (10 != (t = this.getNextToken(st))) {
                    this.makeSixParseErrorMessage(st, sixName, "EOL");
                }
                ++i;
            }
            st.wordChars(47, 122);
            t = this.getNextToken(st);
            if (-3 != t) {
                this.makeSixParseErrorMessage(st, sixName, "</secondindex>");
            }
            if (st.sval.compareToIgnoreCase("</secondindex>") != 0) {
                this.makeSixParseErrorMessage(st, sixName, "</secondindex>");
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                Utils.trace("DsrStatisticDataReader.readTimeIndex(): caught exception: " + e.getClass().getName() + " " + e.getMessage());
            }
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                Utils.trace("DsrStatisticDataReader.readTimeIndex(): caught exception: " + e.getClass().getName() + " " + e.getMessage());
            }
            try {
                if (fr != null) {
                    ((Reader)fr).close();
                }
            }
            catch (IOException e) {
                Utils.trace("DsrStatisticDataReader.readTimeIndex(): caught exception: " + e.getClass().getName() + " " + e.getMessage());
            }
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                Utils.trace("DsrStatisticDataReader.readTimeIndex(): caught exception: " + e.getClass().getName() + " " + e.getMessage());
            }
        }
    }

    private void makeSixParseErrorMessage(StreamTokenizer st, String fileName, String expectedSymbol) throws DsrReaderException {
        throw new DsrReaderException("DsrStatisticDataReader.readTimeIndex(): unexpected token at line: " + st.lineno() + " " + fileName + " .expected: " + expectedSymbol);
    }

    private int getNextToken(StreamTokenizer st) throws DsrReaderException {
        try {
            return st.nextToken();
        }
        catch (Exception e) {
            throw new DsrReaderException("DsrStatisticDataReader.readTimeIndex(): caught exception: " + e.getClass().getName() + " " + e.getMessage(), e);
        }
    }
}

