/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.statistics.api.reader;

import com.sap.js.statistics.api.reader.DsrReaderException;
import com.sap.js.statistics.api.reader.Utils;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Calendar;
import java.util.Comparator;

public class DsrStatFileNameFilter
implements FilenameFilter,
Comparator {
    private long start;
    private long end;
    private String componentDir;
    private int cl;
    private int lenJavaIndic = "_java".length();
    private boolean reverseRead = false;

    public DsrStatFileNameFilter(String compName, String compDir, long startTime, long endTime, boolean reverseRead) throws DsrReaderException {
        this.reverseRead = reverseRead;
        if (compDir == null) {
            throw new DsrReaderException("DsrStatFileNameFilter.DsrStatFileNameFilter(): compDir is null.");
        }
        if (compName == null) {
            throw new DsrReaderException("DsrStatFileNameFilter.DsrStatFileNameFilter(): compName is null.");
        }
        if (0L >= startTime) {
            throw new DsrReaderException("DsrStatFileNameFilter.DsrStatFileNameFilter(): startTime not valid: " + startTime);
        }
        if (0L >= endTime) {
            throw new DsrReaderException("DsrStatFileNameFilter.DsrStatFileNameFilter(): endTime not valid: " + endTime);
        }
        if (startTime > endTime) {
            throw new DsrReaderException("DsrStatFileNameFilter.DsrStatFileNameFilter(): startTime > endTime: " + startTime + " > " + endTime);
        }
        this.componentDir = compDir;
        this.start = startTime;
        this.end = endTime;
        this.cl = compName.length();
    }

    public int compare(Object o1, Object o2) {
        long t2;
        long t1;
        try {
            t1 = DsrStatFileNameFilter.getTimestampFromFile((String)o1);
            t2 = DsrStatFileNameFilter.getTimestampFromFile((String)o2);
        }
        catch (Exception e) {
            Utils.trace("DsrStatFileNameFilter.compare(): caught exception: " + e.getClass().getName() + " " + e.getMessage());
            return 0;
        }
        if (t1 > t2) {
            return this.reverseRead ? -1 : 1;
        }
        if (t1 < t2) {
            return this.reverseRead ? 1 : -1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    private boolean checkNameFormat(String name) {
        int l = name.length();
        if (l < this.cl + 19) {
            return false;
        }
        if (!name.regionMatches(true, l - 19, "_java", 0, this.lenJavaIndic)) {
            return false;
        }
        int i = 5;
        while (i < 15) {
            char c = name.charAt(l - i);
            if ('9' < c) {
                return false;
            }
            if ('0' > c) {
                return false;
            }
            ++i;
        }
        return name.endsWith(".txt");
    }

    private boolean checkTimeIntervall(String name) {
        long t;
        try {
            t = DsrStatFileNameFilter.getTimestampFromFile(name);
        }
        catch (Exception e) {
            Utils.trace("DsrStatFileNameFilter.checkTimeIntervall(): caught exception: " + e.getClass().getName() + " " + e.getMessage());
            return false;
        }
        if (this.start > t + 3599999L) {
            return false;
        }
        return this.end >= t;
    }

    protected static long getTimestampFromFile(String file) throws DsrReaderException {
        long r;
        int l = file.length();
        try {
            Calendar c = Calendar.getInstance(Utils.timezone);
            c.clear();
            int year = new Integer(file.substring(l - 10, l - 10 + 4));
            int month = new Integer(file.substring(l - 12, l - 12 + 2)) - 1;
            int day = new Integer(file.substring(l - 14, l - 14 + 2));
            int hour = new Integer(file.substring(l - 6, l - 6 + 2));
            c.set(year, month, day, hour, 0);
            r = c.getTimeInMillis();
        }
        catch (Exception e) {
            throw new DsrReaderException("DsrStatFileNameFilter.getTimestampFromFile(" + file + "): caught exception: " + e.getClass().getName() + " " + e.getMessage(), e);
        }
        return r;
    }

    @Override
    public boolean accept(File dir, String name) {
        if (dir == null) {
            Utils.trace("DsrStatFileNameFilter.accept(): file is null.");
            return false;
        }
        if (name == null) {
            Utils.trace("DsrStatFileNameFilter.accept(): name is null.");
            return false;
        }
        if (dir.getAbsolutePath().compareToIgnoreCase(this.componentDir) != 0) {
            return false;
        }
        if (!this.checkNameFormat(name)) {
            return false;
        }
        try {
            File f = new File(String.valueOf(this.componentDir) + File.separator + name);
            if (f.isDirectory()) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return this.checkTimeIntervall(name);
    }
}

