/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.statistics.api.writer;

import java.util.Locale;

public class ConvertHelper {
    private static final char[] HEXCHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int HEXRADIX = HEXCHARS.length;

    public static void int2OneByte(int n, byte[] b, int offset) {
        b[offset] = (byte)(n & 0xFF);
    }

    public static void int2TwoByte(int n, byte[] b, int offset) {
        b[offset] = (byte)(0xFF & n >> 8);
        b[offset + 1] = (byte)(n & 0xFF);
    }

    public static void int2FourByte(int n, byte[] b, int offset) {
        b[offset] = (byte)(0xFF & n >> 24);
        b[offset + 1] = (byte)(0xFF & n >> 16);
        b[offset + 2] = (byte)(0xFF & n >> 8);
        b[offset + 3] = (byte)(0xFF & n);
    }

    public static int oneByte2Int(byte[] b, int offset) {
        int r = b[offset];
        if (r < 0) {
            r += 256;
        }
        return r;
    }

    public static int twoByte2Int(byte[] b, int offset) {
        int r1 = b[offset];
        int r2 = b[offset + 1];
        if (r1 < 0) {
            r1 += 256;
        }
        if (r2 < 0) {
            r2 += 256;
        }
        return r1 * 256 + r2;
    }

    public static int fourByte2Int(byte[] b, int offset) {
        int r = b[offset];
        if (r < 0) {
            r += 256;
        }
        int i = 1;
        while (i < 4) {
            int s = b[offset + i];
            if (s < 0) {
                s += 256;
            }
            r = r * 256 + s;
            ++i;
        }
        return r;
    }

    public static String byteArrayToHex(byte[] byteArray) {
        String hex = null;
        if (byteArray != null) {
            char[] charArray = new char[byteArray.length * 2];
            int i = 0;
            int j = 0;
            while (i < byteArray.length) {
                char lowChar;
                char highChar;
                j = 2 * i;
                int halfByte = (byteArray[i] & 0xF0) >> 4;
                charArray[j] = highChar = HEXCHARS[halfByte];
                halfByte = byteArray[i] & 0xF;
                charArray[j + 1] = lowChar = HEXCHARS[halfByte];
                ++i;
            }
            hex = new String(charArray);
        }
        return hex;
    }

    public static byte[] hexToByteArray(String _hex) {
        String hex = _hex.toUpperCase(Locale.ENGLISH);
        int l = hex.length();
        int len = l / 2;
        int count = 0;
        int base = 0;
        int position = 0;
        byte[] result = new byte[len];
        char[] chars = hex.toCharArray();
        int i = 0;
        while (i < l) {
            int index = ConvertHelper.indexOfHex(chars[i]);
            if (index < 0) {
                return null;
            }
            if (position == 0) {
                base = index;
                ++position;
            } else {
                base <<= 4;
                result[count++] = (byte)(base |= index);
                position = 0;
            }
            ++i;
        }
        if (position != 0) {
            return null;
        }
        return result;
    }

    private static int indexOfHex(char hex) {
        int i = 0;
        while (i < HEXRADIX) {
            if (hex == HEXCHARS[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String formatTraceGuid(String str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return null;
        }
        if (len > 32) {
            str = str.substring(0, 32);
        }
        str = str.toUpperCase(Locale.ENGLISH);
        int i = 0;
        while (i < len) {
            if (ConvertHelper.indexOfHex(str.charAt(i)) == -1) {
                return null;
            }
            ++i;
        }
        StringBuilder sb = new StringBuilder(str);
        if (len < 32) {
            int i2 = 0;
            while (i2 < 32 - len) {
                sb.append("0");
                ++i2;
            }
        }
        return sb.toString();
    }
}

