/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.statistics.api.writer;

import com.sap.jdsr.passport.DSRPassport;
import com.sap.jdsr.passport.EncodeDecode;
import com.sap.js.statistics.api.writer.DSRAdmin;
import com.sap.js.statistics.api.writer.DSRConvert;
import com.sap.js.statistics.api.writer.DSRExternalRecord;
import com.sap.js.statistics.api.writer.DSRHTTPRecord;
import com.sap.js.statistics.api.writer.DSRMainRecord;
import com.sap.js.statistics.api.writer.DSRRecord;

public class DSRAction {
    private static final int l1 = 6;
    private static int BUFFER_SIZE = 1024;
    private DSRRecord dsrRec = null;
    private byte[] bufferData = null;
    private int currentBufferSize = 0;
    private int bufOffset = 0;

    public void setDSRRecord(DSRRecord rec) {
        this.dsrRec = rec;
        this.bufferData = new byte[BUFFER_SIZE];
        this.currentBufferSize = BUFFER_SIZE;
    }

    public int getData(byte[] buf, int offset) {
        if (this.bufferData == null) {
            return 0;
        }
        try {
            System.arraycopy(this.bufferData, 0, buf, offset, this.bufOffset);
        }
        catch (Exception exception) {
            return 0;
        }
        return this.bufOffset;
    }

    public void write() {
        if (DSRAdmin.getBufferAdmin() != null) {
            this.fillBuffer();
            DSRAdmin.getBufferAdmin().write(this);
        }
    }

    private void fillBuffer() {
        DSRHTTPRecord httpRec;
        DSRPassport pass;
        int pos;
        if (this.bufferData == null) {
            return;
        }
        DSRMainRecord main = this.dsrRec.getMain();
        if (main != null) {
            pos = main.getData(this.bufferData, this.bufOffset);
            if (pos == 0) {
                this.extendBuffer();
                pos = main.getData(this.bufferData, this.bufOffset);
            }
            this.bufOffset += pos;
            pos = main.getKeyValueFilds(this.bufferData, this.bufOffset);
            if (pos == 0) {
                this.extendBuffer();
                pos = main.getKeyValueFilds(this.bufferData, this.bufOffset);
            }
            this.bufOffset += pos;
        }
        if ((pass = this.dsrRec.getPassport()) != null) {
            pos = this.getPassportArrayData(pass, this.bufferData, this.bufOffset);
            if (pos == 0) {
                this.extendBuffer();
                pos = this.getPassportArrayData(pass, this.bufferData, this.bufOffset);
            }
            this.bufOffset += pos;
        }
        if ((httpRec = this.dsrRec.getHttpRecordInternal()) != null) {
            pos = httpRec.getData(this.bufferData, this.bufOffset);
            if (pos == 0) {
                this.extendBuffer();
                pos = httpRec.getData(this.bufferData, this.bufOffset);
            }
            this.bufOffset += pos;
        }
        DSRExternalRecord[] subRecs = this.dsrRec.getExternals();
        int i = 0;
        while (i < subRecs.length) {
            pos = subRecs[i].getData(this.bufferData, this.bufOffset);
            if (pos == 0) {
                this.extendBuffer();
                pos = subRecs[i].getData(this.bufferData, this.bufOffset);
            }
            this.bufOffset += pos;
            pos = subRecs[i].getConnData(this.bufferData, this.bufOffset);
            if (pos == 0) {
                this.extendBuffer();
                pos = subRecs[i].getConnData(this.bufferData, this.bufOffset);
            }
            this.bufOffset += pos;
            ++i;
        }
    }

    public int getPassportArrayData(DSRPassport pass, byte[] buf, int offset) {
        int pos = offset;
        try {
            DSRConvert.int2FourByte(567898765, buf, pos);
            pos += 6;
            byte[] passBytes = EncodeDecode.encodeBytePassport((DSRPassport)pass);
            if (passBytes != null) {
                buf[pos] = 36;
                buf[++pos] = 3;
                DSRConvert.int2TwoByte(passBytes.length, buf, ++pos);
                System.arraycopy(passBytes, 0, buf, pos += 2, passBytes.length);
                pos += passBytes.length;
            }
            DSRConvert.int2TwoByte(pos - offset, buf, offset + 4);
        }
        catch (Exception exception) {
            return 0;
        }
        return pos - offset;
    }

    private void extendBuffer() {
        this.currentBufferSize += BUFFER_SIZE;
        byte[] newBufferData = new byte[this.currentBufferSize];
        System.arraycopy(this.bufferData, 0, newBufferData, 0, this.bufOffset);
        this.bufferData = newBufferData;
        newBufferData = null;
    }
}

