/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.statistics.api.writer;

import com.sap.js.statistics.api.writer.DSRActionTypes;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class DSRActionStaticData {
    private static final String SID_PROPERTY = "SAPSYSTEMNAME";
    public static final int ACTION_UNKNOWN = 100;
    public static final int ACTION_HTTP = 101;
    public static final int ACTION_HTTPS = 102;
    public static final int ACTION_P4 = 103;
    public static final int ACTION_RFC = 104;
    public static final int ACTION_SYSTEM = 105;
    public static final int SERVICE_UNKNOWN = 100;
    public static final int SERVICE_WEB = 110;
    public static final int SERVICE_EJB = 111;
    public static final int SERVICE_WS = 112;
    public static final int SERVICE_JMS = 113;
    public static final int SERVICE_XI = 114;
    public static final int SERVICE_PORTAL = 115;
    public static final int SERVICE_NWA = 116;
    public static final int SERVICE_WS_SERVER_QUEUE = 117;
    public static final int SERVICE_WS_CLIENT_QUEUE = 118;
    public static final int SERVICE_P4_INTERNAL = 119;
    public static final int SERVICE_ASYNC_ACTION = 120;
    public static final String UNKNOWN = "Unknown";
    private static List<DSRActionTypes> actionTypes;
    private static List<DSRActionTypes> serviceTypes;

    public static void init() {
        actionTypes = new ArrayList<DSRActionTypes>();
        actionTypes.add(new DSRActionTypes(100, UNKNOWN, "Not defined action"));
        actionTypes.add(new DSRActionTypes(101, "HTTP", "Processing request via http protocol"));
        actionTypes.add(new DSRActionTypes(102, "HTTPS", "Processing request via https protocol"));
        actionTypes.add(new DSRActionTypes(103, "P4", "Processing request via p4 protocol"));
        actionTypes.add(new DSRActionTypes(104, "RFC", "Processing request via RFC protocol"));
        actionTypes.add(new DSRActionTypes(105, "SYSTEM", "Backgrownd process"));
        serviceTypes = new ArrayList<DSRActionTypes>();
        serviceTypes.add(new DSRActionTypes(100, UNKNOWN, "Not defined service"));
        serviceTypes.add(new DSRActionTypes(110, "Web Request", "Request which accesses the Web Container"));
        serviceTypes.add(new DSRActionTypes(111, "EJB Request", "Request which accesses the EJB Container"));
        serviceTypes.add(new DSRActionTypes(112, "Web Service", "Request which accesses the Web Services"));
        serviceTypes.add(new DSRActionTypes(113, "JMS", "JMS message processing"));
        serviceTypes.add(new DSRActionTypes(114, "XI processing", "XI message processing"));
        serviceTypes.add(new DSRActionTypes(115, "Portal", "Portal request"));
        serviceTypes.add(new DSRActionTypes(117, "WS Server Queue", "Web Service asynchronous server queue"));
        serviceTypes.add(new DSRActionTypes(118, "WS Client Queue", "Web Service asynchronous client queue"));
        serviceTypes.add(new DSRActionTypes(116, "NWA", "NWA plugin request"));
        serviceTypes.add(new DSRActionTypes(119, "P4 internal", "Invokation of a class via P4"));
        serviceTypes.add(new DSRActionTypes(120, "Async action", "Asynchronous action"));
    }

    public static String getType() {
        return "SAPJ2ENode";
    }

    public static String getVersion() {
        return "2.0";
    }

    public static Enumeration getLinkedSystems() {
        Vector<String> res = new Vector<String>();
        String linkedSystem = System.getProperty(SID_PROPERTY);
        if (linkedSystem != null) {
            res.add(linkedSystem);
        }
        return res.elements();
    }

    public static List<DSRActionTypes> getActionTypes() {
        return actionTypes;
    }

    public static List<DSRActionTypes> getServiceTypes() {
        return serviceTypes;
    }

    public static String getActionName(int actionType) {
        for (DSRActionTypes type : actionTypes) {
            if (type.getTypeId() != actionType) continue;
            return type.getTypeName();
        }
        return UNKNOWN;
    }

    public static String getServiceName(int serviceType) {
        for (DSRActionTypes type : serviceTypes) {
            if (type.getTypeId() != serviceType) continue;
            return type.getTypeName();
        }
        return UNKNOWN;
    }
}

