/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.statistics.api.writer;

import com.sap.js.statistics.api.writer.DSRActionStaticData;
import com.sap.js.statistics.api.writer.DSRBufferAdmin;
import com.sap.js.statistics.api.writer.DSRStatFileFilter;
import com.sap.js.statistics.api.writer.DSRTrace;
import java.io.File;
import java.util.Arrays;

public class DSRAdmin {
    private static String dsrRoot = null;
    private static String dsrComponent = null;
    private static int maxFileCount = 4;
    private static int buffSize = 0x100000;
    private static String compDir = null;
    private static long lastChangeTime = 0L;
    private static String portFileName;
    private static DSRBufferAdmin bufferAdmin;

    static {
        bufferAdmin = null;
    }

    public static void init(String rootDir, String dsrComp) {
        dsrRoot = rootDir;
        dsrComponent = dsrComp;
        DSRActionStaticData.init();
        StringBuffer b = new StringBuffer(512);
        b.append(dsrRoot);
        if (File.separatorChar != dsrRoot.charAt(dsrRoot.length() - 1)) {
            b.append(File.separatorChar);
        }
        b.append(dsrComponent);
        b.append("_java");
        compDir = b.toString();
        File dir = new File(compDir);
        if (dir == null) {
            DSRTrace.logError("DsrAdmin: createComponentDirectory(): new File(" + compDir + ") failed.");
            return;
        }
        if (!dir.exists() && !dir.mkdirs()) {
            DSRTrace.logError("DsrAdmin: Could not cerate comp dir: " + dir.getAbsolutePath());
        }
        if (!dir.isDirectory()) {
            DSRTrace.logError("DsrAdmin: Could not cerate comp dir because the constructed dir is not directory");
            return;
        }
        StringBuffer sb = new StringBuffer(512);
        sb.append(dsrRoot);
        if (File.separatorChar != dsrRoot.charAt(dsrRoot.length() - 1)) {
            sb.append(File.separatorChar);
        }
        sb.append("dsrports.txt");
        portFileName = sb.toString();
        if (DSRTrace.isDumpActive()) {
            DSRTrace.dump("PortaFile name is: " + portFileName);
        }
        bufferAdmin = new DSRBufferAdmin();
    }

    public static boolean clean() {
        if (bufferAdmin != null) {
            bufferAdmin.syncFlush();
        }
        if (compDir == null) {
            DSRTrace.logError("DsrAdmin.clean(): DSR root folder is null");
            return false;
        }
        File dsrs = new File(compDir);
        if (dsrs == null || !dsrs.isDirectory()) {
            DSRTrace.logError("DsrAdmin: DSR root is not a correct folder");
            return false;
        }
        String[] files = dsrs.list();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                File f = new File(String.valueOf(compDir) + File.separator + files[i]);
                if (f != null && f.exists()) {
                    f.delete();
                }
                ++i;
            }
        }
        return true;
    }

    public static boolean flush() {
        if (bufferAdmin != null) {
            return bufferAdmin.flush();
        }
        return false;
    }

    public static boolean syncFlush() {
        return bufferAdmin.syncFlush();
    }

    public static boolean isFlushCompleted() {
        if (bufferAdmin != null) {
            return bufferAdmin.isFlushCompleted();
        }
        return false;
    }

    public static long getLastChangeTime() {
        return lastChangeTime;
    }

    public static String getDsrRoot() {
        return dsrRoot;
    }

    public static DSRActionStaticData getStaticData() {
        return null;
    }

    public static String getComponent() {
        if (dsrComponent == null) {
            return "NotDefinedComp";
        }
        return dsrComponent;
    }

    public static String getCompDir() {
        if (compDir == null) {
            return "\\dsr";
        }
        return compDir;
    }

    public static DSRBufferAdmin getBufferAdmin() {
        return bufferAdmin;
    }

    public static void setMaxFileCount(int count) {
        if (count < -1 || count == 0) {
            return;
        }
        maxFileCount = count;
    }

    public static int getMaxFileCount() {
        return maxFileCount;
    }

    public static int getBufSize() {
        return buffSize;
    }

    public static void deleteOldStatFiles() {
        String componentDir = null;
        File compDirFile = null;
        File[] statFiles = null;
        int maxCount = 0;
        DSRStatFileFilter f = null;
        componentDir = DSRAdmin.getCompDir();
        if (componentDir == null) {
            if (DSRTrace.isDumpActive()) {
                DSRTrace.dump("DsrBuffer: deleteOldStatFiles() failed.");
            }
            return;
        }
        if (DSRTrace.isDumpActive()) {
            DSRTrace.dump("DsrBuffer: deleteOldStatFiles(): component dir is: " + componentDir);
        }
        if (-1 == (maxCount = DSRAdmin.getMaxFileCount())) {
            if (DSRTrace.isDumpActive()) {
                DSRTrace.dump("DsrBuffer: deleteOldStatFiles(): DsrAdmin.getStatFileMaxCount() failed.");
            }
            return;
        }
        if (DSRTrace.isDumpActive()) {
            DSRTrace.dump(String.valueOf(DSRAdmin.getMaxFileCount()) + " is " + maxCount);
        }
        if ((statFiles = (compDirFile = new File(componentDir)).listFiles(f = new DSRStatFileFilter(DSRAdmin.getComponent()))) != null) {
            if (statFiles.length <= maxCount) {
                if (DSRTrace.isDumpActive()) {
                    DSRTrace.dump("DsrBuffer: deleteOldStatFiles(): nothing to delete.");
                }
                return;
            }
            Arrays.sort(statFiles, f);
            int deleteCount = statFiles.length - 2 * maxCount;
            if (DSRTrace.isDumpActive()) {
                DSRTrace.dump("DsrBuffer: deleteOldStatFiles(): " + deleteCount + " files to delete.");
            }
            int i = 0;
            while (i < deleteCount) {
                if (DSRTrace.isDumpActive()) {
                    DSRTrace.dump("DsrBuffer: deleteOldStatFiles(): deleting: " + statFiles[i].getName());
                }
                statFiles[i].delete();
                ++i;
            }
        }
    }
}

