/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.statistics.api.writer;

import com.sap.js.statistics.api.writer.DSRAdmin;
import com.sap.js.statistics.api.writer.DSRConstants;
import com.sap.js.statistics.api.writer.DSRConvert;
import com.sap.js.statistics.api.writer.DSRTrace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Calendar;
import java.util.Date;

public class DSRBuffer {
    private static final int FAILED_RETURN_CODE = -4711;
    public static final int fileNameLen = 512;
    private static final String secondIndexStartToken = "<secondindex>";
    private static final String secondIndexEndToken = "</secondindex>";
    private static final String lastRecFileNameString = "dsrlastrec.txt";
    private static final char[] colon = new char[]{':'};
    private static final char[] semicolon = new char[]{';'};
    private int bufferLen = 0;
    private byte[] buffer = null;
    private int bufferPosition = 0;
    private long currentHour = -1L;
    private String statFileName = null;
    private String lastRecFileName = null;
    private final long[] secondIndexBuffer = new long[3600];
    private long lastRecordTimestamp;
    private final StringBuffer strBuffer = new StringBuffer(512);
    private final Calendar calendar = Calendar.getInstance(DSRConstants.timezone);
    private final Date date = new Date();
    private static final int l1 = 6;
    private static final int l2 = 14;
    private String sixFileName = null;
    private BufferedReader bufferedSixFileReader = null;
    private final StringBuilder sixStrBuffer = new StringBuilder(2000);
    private final StringBuilder readStringBuffer = new StringBuilder(128);
    private final long[] secondIndex = new long[3600];

    protected DSRBuffer() {
        int i = 0;
        while (i < 3600) {
            this.secondIndexBuffer[i] = -1L;
            ++i;
        }
        this.bufferLen = DSRAdmin.getBufSize();
        this.buffer = new byte[this.bufferLen];
    }

    protected void updateLastRecordTimestamp(long t) {
        this.lastRecordTimestamp = t;
    }

    protected void writeLastRecordTimestamp() throws IOException {
        RandomAccessFile outputFile = null;
        try {
            File oldFile = new File(this.lastRecFileName);
            oldFile.delete();
            outputFile = new RandomAccessFile(this.lastRecFileName, "rw");
            outputFile.write(new Long(this.lastRecordTimestamp).toString().getBytes("UTF-8"));
        }
        catch (Throwable throwable) {
            if (outputFile != null) {
                try {
                    outputFile.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (outputFile != null) {
            try {
                outputFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void writeTimestamp(long t) {
        DSRConvert.long2EightByte(t / 1000L, this.buffer, this.bufferPosition + 6);
        DSRConvert.int2TwoByte((int)(t % 1000L), this.buffer, this.bufferPosition + 14);
    }

    private void clearSecondIndex() {
        int i = 0;
        while (i < 3600) {
            this.secondIndex[i] = -1L;
            ++i;
        }
    }

    private void mergeSecondIndex(long offset) {
        int i = 0;
        while (i < 3600) {
            if (-1L < this.secondIndexBuffer[i] && -1L == this.secondIndex[i]) {
                this.secondIndex[i] = this.secondIndexBuffer[i] + offset;
            }
            ++i;
        }
    }

    protected void updateSecondIndexBuffer(long time) {
        int index = (int)(time - this.currentHour) / 1000;
        if (-1L == this.secondIndexBuffer[index]) {
            this.secondIndexBuffer[index] = this.bufferPosition;
            if (DSRTrace.isDumpActive()) {
                DSRTrace.dump("DsrBuffer: updateSecondIndexBuffer(): updating: " + index + " " + this.bufferPosition);
            }
        }
    }

    public void writeToFile() {
        long secondIndexOffset = 0L;
        FileOutputStream os = null;
        File outputFile = null;
        if (DSRTrace.isDumpActive()) {
            DSRTrace.dump("DsrBuffer: writeToFile() entered.");
        }
        if (this.bufferPosition == 0) {
            if (DSRTrace.isDumpActive()) {
                DSRTrace.dump("DsrBuffer: writeToFile(): nothing to flush.");
            }
            return;
        }
        try {
            outputFile = new File(this.statFileName);
            os = new FileOutputStream(this.statFileName, true);
            this.readIndexFile(this.sixFileName);
            secondIndexOffset = outputFile.length();
            if (DSRTrace.isDumpActive()) {
                DSRTrace.dump("DsrBuffer: writeToFile(): about to flush.");
            }
            os.write(this.buffer, 0, this.bufferPosition);
            os.flush();
            if (DSRTrace.isDumpActive()) {
                DSRTrace.dump("DsrBuffer: writeToFile(): flush done: " + this.bufferPosition + " bytes.");
            }
            os.close();
            this.mergeSecondIndex(secondIndexOffset);
            this.writeLastRecordTimestamp();
            this.writeIndexFile();
            DSRAdmin.deleteOldStatFiles();
        }
        catch (IOException e) {
            DSRTrace.dumpError(e);
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e3) {
                DSRTrace.dumpError(e3);
            }
        }
        if (DSRTrace.isDumpActive()) {
            DSRTrace.dump("DsrBuffer: writeToFile(): flush thread ends here.");
        }
    }

    protected void clear() {
        this.bufferPosition = 0;
    }

    protected int getCurrentWritePosition() {
        return this.bufferPosition;
    }

    protected boolean setCurrentWritePositionByIncrement(int p) {
        if (this.bufferLen < p + this.bufferPosition) {
            if (DSRTrace.isDumpActive()) {
                DSRTrace.dump("DsrBuffer: setCurrentWritePositionByIncrement(): cannot increment position: " + p + this.bufferPosition + this.bufferLen);
            }
            return false;
        }
        if (DSRTrace.isDumpActive()) {
            DSRTrace.dump("DsrBuffer: setCurrentWritePositionByIncrement(): increment position: " + p + this.bufferPosition + this.bufferLen);
        }
        this.bufferPosition += p;
        return true;
    }

    protected byte[] getBuffer() {
        return this.buffer;
    }

    protected void refreshHour(long time) {
        this.date.setTime(time);
        this.calendar.setTime(this.date);
        int d = this.calendar.get(5);
        int m = this.calendar.get(2) + 1;
        int y = this.calendar.get(1);
        int h = this.calendar.get(11);
        boolean sepThere = false;
        String s = DSRAdmin.getCompDir();
        if (File.separatorChar == s.charAt(s.length() - 1)) {
            sepThere = true;
        }
        if (this.strBuffer.length() > 0) {
            this.strBuffer.delete(0, this.strBuffer.length());
        }
        this.strBuffer.append(s);
        this.strBuffer.append(sepThere ? "" : File.separator);
        this.strBuffer.append(DSRAdmin.getComponent());
        this.strBuffer.append("_java");
        this.strBuffer.append(9 < d ? "" : "0");
        this.strBuffer.append(d);
        this.strBuffer.append(9 < m ? "" : "0");
        this.strBuffer.append(m);
        this.strBuffer.append(y);
        this.strBuffer.append(9 < h ? "" : "0");
        this.strBuffer.append(h);
        this.strBuffer.append(".txt");
        this.statFileName = new String(this.strBuffer);
        if (DSRTrace.isDumpActive()) {
            DSRTrace.dump("DsrBuffer: refreshHour(): new statfile name is: " + this.statFileName);
        }
        if (this.strBuffer.length() > 0) {
            this.strBuffer.delete(0, this.strBuffer.length());
        }
        this.strBuffer.append(this.statFileName.substring(0, this.statFileName.length() - ".txt".length()));
        this.strBuffer.append(".six");
        this.sixFileName = new String(this.strBuffer);
        if (DSRTrace.isDumpActive()) {
            DSRTrace.dump("DsrBuffer: refreshHour(): new sixfile name is: " + this.sixFileName);
        }
        if (this.lastRecFileName == null) {
            if (this.strBuffer.length() > 0) {
                this.strBuffer.delete(0, this.strBuffer.length());
            }
            this.strBuffer.append(s);
            this.strBuffer.append(sepThere ? "" : File.separator);
            this.strBuffer.append(lastRecFileNameString);
            this.lastRecFileName = new String(this.strBuffer);
        }
        if (DSRTrace.isDumpActive()) {
            DSRTrace.dump("DsrBuffer: refreshHour(): new lastRecFileName name is: " + this.lastRecFileName);
        }
        this.currentHour = time - (long)this.calendar.get(14) - (long)this.calendar.get(13) * 1000L - (long)this.calendar.get(12) * 60000L;
        if (DSRTrace.isDumpActive()) {
            DSRTrace.dump("DsrBuffer: refreshHour(): new currentHour is: " + this.currentHour);
        }
        this.bufferPosition = 0;
        int i = 0;
        while (i < 3600) {
            this.secondIndexBuffer[i] = -1L;
            ++i;
        }
    }

    protected boolean hasCurrentHourChanged(long time) {
        return time - this.currentHour >= 3600000L;
    }

    private void writeIndexFile() throws IOException {
        RandomAccessFile f = null;
        try {
            f = new RandomAccessFile(this.sixFileName, "rw");
            f.setLength(0L);
            this.sixStrBuffer.setLength(0);
            this.sixStrBuffer.append(secondIndexStartToken);
            this.sixStrBuffer.append("\n");
            int i = 0;
            while (i < 3600) {
                this.sixStrBuffer.append(i);
                this.sixStrBuffer.append(" : ");
                this.sixStrBuffer.append(this.secondIndex[i]);
                this.sixStrBuffer.append(" ;\n");
                ++i;
            }
            this.sixStrBuffer.append(secondIndexEndToken);
            if (DSRTrace.isDumpActive()) {
                DSRTrace.dump("DsrBuffer: writeSecondIndex()");
            }
            f.write(this.sixStrBuffer.toString().getBytes("UTF-8"));
        }
        catch (Throwable throwable) {
            if (f != null) {
                try {
                    f.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (f != null) {
            try {
                f.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * Exception decompiling
     */
    private void readIndexFile(String fileName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [48[WHILELOOP]], but top level block is 16[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean readToken(char[] t) throws IOException {
        int pos = 0;
        char[] s = new char[t.length];
        int c = 0;
        while (c < s.length) {
            s[c] = '\u0000';
            ++c;
        }
        c = this.skipLeadingBlanks();
        if (-1 == c) {
            return false;
        }
        while (!Character.isWhitespace((char)c)) {
            if (pos >= s.length) {
                return false;
            }
            s[pos] = (char)c;
            ++pos;
            c = this.bufferedSixFileReader.read();
            if (-1 != c) continue;
        }
        if (pos != s.length) {
            return false;
        }
        c = 0;
        while (c < t.length) {
            if (s[c] != t[c]) {
                return false;
            }
            ++c;
        }
        return true;
    }

    private boolean readSecondIndexEntry(int entryNumber) throws IOException {
        long offset;
        int index;
        String intValue = this.readValue();
        try {
            index = Integer.parseInt(new String(intValue));
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        if (index == -1) {
            return false;
        }
        if (entryNumber != index) {
            return false;
        }
        if (!this.readToken(colon)) {
            return false;
        }
        String longValue = this.readValue();
        try {
            offset = Long.parseLong(new String(longValue));
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        if (-1L > offset) {
            return false;
        }
        if (!this.readToken(semicolon)) {
            return false;
        }
        this.secondIndex[index] = offset;
        return true;
    }

    private String readValue() throws IOException {
        int pos = 0;
        StringBuilder r = this.readStringBuffer;
        r.setLength(0);
        int c = this.skipLeadingBlanks();
        if (-4711 == c) {
            return null;
        }
        while (!Character.isWhitespace((char)c)) {
            if (pos >= r.capacity()) {
                return null;
            }
            if (!Character.isDigit((char)c) && '-' != (char)c) {
                return null;
            }
            r.append((char)c);
            ++pos;
            c = this.bufferedSixFileReader.read();
            if (-1 != c) continue;
        }
        return new String(r);
    }

    private int skipLeadingBlanks() throws IOException {
        int c;
        while (-1 != (c = this.bufferedSixFileReader.read())) {
            if (!Character.isWhitespace((char)c)) break;
        }
        if (-1 == c) {
            return -4711;
        }
        return c;
    }
}

