/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.statistics.api.writer;

import com.sap.js.statistics.api.writer.DSRAction;
import com.sap.js.statistics.api.writer.DSRBuffer;
import com.sap.js.statistics.api.writer.DSRTrace;

public class DSRBufferAdmin {
    private DSRBuffer[] bufferArray = new DSRBuffer[2];
    private DSRBuffer bufferToFlush = null;
    private int activeBuffer = 0;
    private int passiveBuffer = 1;
    private boolean isFlushWorking = false;
    private boolean bufferJustSwaped = false;
    private boolean isFlushPostponed = false;

    protected DSRBufferAdmin() {
        this.bufferArray[0] = new DSRBuffer();
        this.bufferArray[1] = new DSRBuffer();
        this.activeBuffer = 0;
        this.passiveBuffer = (this.activeBuffer + 1) % 2;
        this.bufferArray[this.activeBuffer].refreshHour(System.currentTimeMillis());
    }

    protected synchronized boolean flush() {
        if (DSRTrace.isDumpActive()) {
            DSRTrace.dump("DsrBufferAdmin: flush(): entered.");
        }
        return this.switchBuffer(System.currentTimeMillis());
    }

    protected synchronized boolean syncFlush() {
        if (DSRTrace.isDumpActive()) {
            DSRTrace.dump("DsrBufferAdmin: syncFlush(): entered.");
        }
        return this.switchBuffer(System.currentTimeMillis(), true);
    }

    protected boolean write(DSRAction s) {
        if (DSRTrace.isDumpActive()) {
            DSRTrace.dump("DsrBufferAdmin: write(): entered.");
        }
        if (s == null) {
            if (DSRTrace.isDumpActive()) {
                DSRTrace.dump("DsrBufferAdmin: write(): no record set.");
            }
            return false;
        }
        if (!this.writeSync(s, System.currentTimeMillis())) {
            return this.writeSync(s, System.currentTimeMillis());
        }
        return true;
    }

    protected boolean isFlushCompleted() {
        return !this.isFlushWorking;
    }

    private boolean switchBuffer(long time) {
        return this.switchBuffer(time, false);
    }

    private boolean switchBuffer(long time, boolean synchronously) {
        block7: {
            if (this.isFlushWorking) {
                return false;
            }
            this.bufferToFlush = this.bufferArray[this.activeBuffer];
            this.isFlushWorking = true;
            try {
                if (synchronously) {
                    try {
                        this.bufferToFlush.writeToFile();
                        this.bufferToFlush.clear();
                        break block7;
                    }
                    finally {
                        this.isFlushWorking = false;
                    }
                }
                FlushThread flushThread = new FlushThread();
                flushThread.setName("SAPDSR_flush");
                flushThread.start();
            }
            catch (Exception exception) {
                this.isFlushWorking = false;
                this.isFlushPostponed = true;
            }
        }
        this.activeBuffer = this.passiveBuffer;
        this.passiveBuffer = (this.activeBuffer + 1) % 2;
        this.bufferArray[this.activeBuffer].refreshHour(time);
        return true;
    }

    private synchronized boolean writeSync(DSRAction s, long time) {
        int recordLen;
        block12: {
            this.bufferJustSwaped = false;
            if (this.isFlushPostponed && Thread.currentThread().isAlive()) {
                try {
                    try {
                        this.isFlushWorking = true;
                        FlushThread flushThread = new FlushThread();
                        flushThread.setName("SAPDSR_flush");
                        flushThread.start();
                    }
                    catch (Exception exception) {
                        this.isFlushWorking = false;
                        this.isFlushPostponed = false;
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    this.isFlushPostponed = false;
                    throw throwable;
                }
                this.isFlushPostponed = false;
            }
        }
        if (this.bufferArray[this.activeBuffer].hasCurrentHourChanged(time)) {
            if (!this.switchBuffer(time)) {
                return false;
            }
            this.bufferJustSwaped = true;
        }
        if ((recordLen = s.getData(this.bufferArray[this.activeBuffer].getBuffer(), this.bufferArray[this.activeBuffer].getCurrentWritePosition())) == 0) {
            if (this.bufferJustSwaped) {
                return false;
            }
            if (!this.switchBuffer(time)) {
                return false;
            }
            recordLen = s.getData(this.bufferArray[this.activeBuffer].getBuffer(), this.bufferArray[this.activeBuffer].getCurrentWritePosition());
            if (recordLen <= 0) {
                return false;
            }
        }
        this.bufferArray[this.activeBuffer].writeTimestamp(time);
        this.bufferArray[this.activeBuffer].updateSecondIndexBuffer(time);
        this.bufferArray[this.activeBuffer].setCurrentWritePositionByIncrement(recordLen);
        this.bufferArray[this.activeBuffer].updateLastRecordTimestamp(time / 1000L);
        return true;
    }

    private class FlushThread
    extends Thread {
        private FlushThread() {
        }

        @Override
        public void run() {
            try {
                DSRBufferAdmin.this.bufferToFlush.writeToFile();
                DSRBufferAdmin.this.bufferToFlush.clear();
            }
            finally {
                DSRBufferAdmin.this.isFlushWorking = false;
            }
        }
    }
}

