/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.statistics.api.writer;

public class DSRConvert {
    public static void int2OneByte(int n, byte[] b, int offset) {
        b[offset] = (byte)(n & 0xFF);
    }

    public static void int2TwoByte(int n, byte[] b, int offset) {
        b[offset] = (byte)(0xFF & n >> 8);
        b[offset + 1] = (byte)(n & 0xFF);
    }

    public static void int2FourByte(int n, byte[] b, int offset) {
        b[offset] = (byte)(0xFF & n >> 24);
        b[offset + 1] = (byte)(0xFF & n >> 16);
        b[offset + 2] = (byte)(0xFF & n >> 8);
        b[offset + 3] = (byte)(0xFF & n);
    }

    public static void long2EightByte(long n, byte[] b, int offset) {
        b[offset] = (byte)(0xFFL & n >> 56);
        b[offset + 1] = (byte)(0xFFL & n >> 48);
        b[offset + 2] = (byte)(0xFFL & n >> 40);
        b[offset + 3] = (byte)(0xFFL & n >> 32);
        b[offset + 4] = (byte)(0xFFL & n >> 24);
        b[offset + 5] = (byte)(0xFFL & n >> 16);
        b[offset + 6] = (byte)(0xFFL & n >> 8);
        b[offset + 7] = (byte)(n & 0xFFL);
    }

    public static int oneByte2Int(byte[] b, int offset) {
        int r = b[offset];
        if (r < 0) {
            r += 256;
        }
        return r;
    }

    public static int twoByte2Int(byte[] b, int offset) {
        int r1 = b[offset];
        int r2 = b[offset + 1];
        if (r1 < 0) {
            r1 += 256;
        }
        if (r2 < 0) {
            r2 += 256;
        }
        return r1 * 256 + r2;
    }

    public static int fourByte2Int(byte[] b, int offset) {
        int r = b[offset];
        if (r < 0) {
            r += 256;
        }
        int i = 1;
        while (i < 4) {
            int s = b[offset + i];
            if (s < 0) {
                s += 256;
            }
            r = r * 256 + s;
            ++i;
        }
        return r;
    }

    public static long eightByte2Long(byte[] b, int offset) {
        long r = b[offset];
        if (0L > r) {
            r += 256L;
        }
        int i = 1;
        while (i < 8) {
            int s = b[offset + i];
            if (s < 0) {
                s += 256;
            }
            r = r * 256L + (long)s;
            ++i;
        }
        return r;
    }
}

