/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.statistics.api.writer;

import com.sap.js.statistics.api.DSRIExternalRecord;
import com.sap.js.statistics.api.writer.DSRConvert;

public class DSRExternalRecord
implements DSRIExternalRecord {
    private static final int l1 = 6;
    private long callTime;
    private long receivedBytes;
    private long sentBytes;
    private String destination;
    private String addInfo;
    private String systemId;
    private byte[] connectionId;
    private int connectionCounter;
    private String externalType;

    public DSRExternalRecord() {
    }

    public DSRExternalRecord(long callTime, long receivedBytes, long sentBytes, String destination, String addInfo, String systemId, int connectionCounter, byte[] connectionId, String type) {
        this.callTime = callTime;
        this.receivedBytes = receivedBytes;
        this.sentBytes = sentBytes;
        this.destination = destination;
        this.addInfo = addInfo;
        this.systemId = systemId;
        this.connectionCounter = connectionCounter;
        if (connectionId != null) {
            this.connectionId = new byte[connectionId.length];
            System.arraycopy(connectionId, 0, this.connectionId, 0, connectionId.length);
        }
        this.externalType = type;
    }

    @Override
    public String getAddInfo() {
        return this.addInfo;
    }

    @Override
    public long getCallTime() {
        return this.callTime;
    }

    @Override
    public String getDestination() {
        return this.destination;
    }

    @Override
    public long getReceivedBytes() {
        return this.receivedBytes;
    }

    @Override
    public long getSentBytes() {
        return this.sentBytes;
    }

    @Override
    @Deprecated
    public int getType() {
        return 0;
    }

    @Override
    public String getTypeString() {
        return this.externalType;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public byte[] getConnectionId() {
        return this.connectionId;
    }

    @Override
    public int getConnectionCounter() {
        return this.connectionCounter;
    }

    public void setAddInfo(String addInfo) {
        this.addInfo = addInfo;
    }

    public void setCallTime(long callTime) {
        this.callTime = callTime;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public void setReceivedBytes(long receivedBytes) {
        this.receivedBytes = receivedBytes;
    }

    public void setSentBytes(long sentBytes) {
        this.sentBytes = sentBytes;
    }

    public void setConnectionCounter(int connectionCounter) {
        this.connectionCounter = connectionCounter;
    }

    public void setConnectionId(byte[] connectionId) {
        this.connectionId = new byte[connectionId.length];
        System.arraycopy(connectionId, 0, this.connectionId, 0, connectionId.length);
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void setTypeString(String type) {
        this.externalType = type;
    }

    public int getData(byte[] buf, int offset) {
        int pos = offset;
        byte[] temp = null;
        try {
            DSRConvert.int2FourByte(345676543, buf, pos);
            pos += 6;
            if (0L != this.callTime) {
                buf[pos] = 16;
                buf[++pos] = 1;
                DSRConvert.long2EightByte(this.callTime, buf, ++pos);
                pos += 8;
            }
            if (0L != this.sentBytes) {
                buf[pos] = 23;
                buf[++pos] = 1;
                DSRConvert.long2EightByte(this.sentBytes, buf, ++pos);
                pos += 8;
            }
            if (0L != this.receivedBytes) {
                buf[pos] = 21;
                buf[++pos] = 1;
                DSRConvert.long2EightByte(this.receivedBytes, buf, ++pos);
                pos += 8;
            }
            if (this.externalType != null) {
                temp = this.externalType.getBytes("UTF-8");
                buf[pos] = 18;
                buf[++pos] = 2;
                DSRConvert.int2TwoByte(temp.length, buf, ++pos);
                System.arraycopy(temp, 0, buf, pos += 2, temp.length);
                pos += temp.length;
            }
            if (this.destination != null) {
                temp = this.destination.getBytes("UTF-8");
                buf[pos] = 19;
                buf[++pos] = 2;
                DSRConvert.int2TwoByte(temp.length, buf, ++pos);
                System.arraycopy(temp, 0, buf, pos += 2, temp.length);
                pos += temp.length;
            }
            if (this.systemId != null) {
                temp = this.systemId.getBytes("UTF-8");
                buf[pos] = 17;
                buf[++pos] = 2;
                DSRConvert.int2TwoByte(temp.length, buf, ++pos);
                System.arraycopy(temp, 0, buf, pos += 2, temp.length);
                pos += temp.length;
            }
            if (this.addInfo != null) {
                temp = this.addInfo.getBytes("UTF-8");
                buf[pos] = 2;
                buf[++pos] = 2;
                DSRConvert.int2TwoByte(temp.length, buf, ++pos);
                System.arraycopy(temp, 0, buf, pos += 2, temp.length);
                pos += temp.length;
            }
            DSRConvert.int2TwoByte(pos - offset, buf, offset + 4);
        }
        catch (Exception exception) {
            return 0;
        }
        return pos - offset;
    }

    public int getConnData(byte[] buf, int offset) {
        byte[] temp;
        int pos;
        block5: {
            pos = offset;
            temp = null;
            try {
                if (this.connectionId != null) break block5;
                return 0;
            }
            catch (Exception exception) {
                return 0;
            }
        }
        DSRConvert.int2FourByte(901232109, buf, pos);
        pos += 6;
        if (this.connectionId != null) {
            temp = this.connectionId;
            buf[pos] = 35;
            buf[++pos] = 3;
            DSRConvert.int2TwoByte(temp.length, buf, ++pos);
            System.arraycopy(temp, 0, buf, pos += 2, temp.length);
            pos += temp.length;
        }
        if (this.connectionCounter != 0) {
            buf[pos] = 34;
            buf[++pos] = 0;
            DSRConvert.int2FourByte(this.connectionCounter, buf, ++pos);
            pos += 4;
        }
        DSRConvert.int2TwoByte(pos - offset, buf, offset + 4);
        return pos - offset;
    }
}

