/*
 * Decompiled with CFR 0.152.
 */
package com.sap.js.statistics.api.writer;

import com.sap.js.statistics.api.DSRIMainRecord;
import com.sap.js.statistics.api.writer.DSRConstants;
import com.sap.js.statistics.api.writer.DSRConvert;
import java.io.UnsupportedEncodingException;

public class DSRMainRecord
implements DSRIMainRecord {
    private static final int l1 = 16;
    private static final int l2 = 6;
    private String transId;
    private String action;
    private String userId;
    private String account;
    private String addInfo;
    private long startTime;
    private int serviceType;
    private int actionType;
    private long respTime;
    private long cpuTime;
    private long allocMem;
    private long dbTime;
    private long extTime;
    private long receivedBytes;
    private long sentBytes;
    private int dbCalls;
    private long dbIO;
    private int sessionSize;
    private byte[] transIdBytes;
    private byte[] actionBytes;
    private byte[] userIdBytes;
    private byte[] addInfoBytes;

    public DSRMainRecord() {
    }

    public DSRMainRecord(String transId, String action, String userId, String account, String addInfo, long startTime, int serviceType, int actionType, long respTime, long cpuTime, long allocMem, long dbTime, long extTime, long receivedBytes, long sentBytes) {
        try {
            this.transId = transId;
            if (transId != null) {
                this.transIdBytes = transId.getBytes("UTF-8");
            }
            this.action = action;
            if (action != null) {
                this.actionBytes = action.getBytes("UTF-8");
            }
            this.userId = userId;
            if (userId != null) {
                this.userIdBytes = userId.getBytes("UTF-8");
            }
            this.addInfo = addInfo;
            if (addInfo != null) {
                this.addInfoBytes = addInfo.getBytes("UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        this.account = account;
        this.startTime = startTime;
        this.serviceType = serviceType;
        this.actionType = actionType;
        this.respTime = respTime;
        this.cpuTime = cpuTime;
        this.allocMem = allocMem;
        this.dbTime = dbTime;
        this.extTime = extTime;
        this.receivedBytes = receivedBytes;
        this.sentBytes = sentBytes;
    }

    @Override
    public String getTransId() {
        return this.transId;
    }

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public String getAccount() {
        return this.account;
    }

    @Override
    public int getServiceType() {
        return this.serviceType;
    }

    @Override
    public int getActionType() {
        return this.actionType;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getRespTime() {
        return this.respTime;
    }

    @Override
    public long getCpuTime() {
        return this.cpuTime;
    }

    @Override
    public long getAllocMem() {
        return this.allocMem;
    }

    @Override
    public long getDbTime() {
        return this.dbTime;
    }

    @Override
    public long getExternalTime() {
        return this.extTime;
    }

    @Override
    public long getReceivedBytes() {
        return this.receivedBytes;
    }

    @Override
    public long getSentBytes() {
        return this.sentBytes;
    }

    @Override
    public String getAddInfo() {
        return this.addInfo;
    }

    public int getData(byte[] buf, int offset) {
        int pos = offset;
        try {
            DSRConvert.int2FourByte(123454321, buf, pos);
            pos += 16;
            if (0L != this.startTime) {
                buf[pos] = 12;
                buf[++pos] = 1;
                DSRConvert.long2EightByte(this.startTime / 1000L, buf, ++pos);
                buf[pos += 8] = 28;
                buf[++pos] = 0;
                DSRConvert.int2FourByte((int)(this.startTime % 1000L), buf, ++pos);
                pos += 4;
            }
            if (this.serviceType != 0) {
                buf[pos] = 11;
                buf[++pos] = 0;
                DSRConvert.int2FourByte(this.serviceType, buf, ++pos);
                pos += 4;
            }
            if (this.actionType != 0) {
                buf[pos] = 1;
                buf[++pos] = 0;
                DSRConvert.int2FourByte(this.actionType, buf, ++pos);
                pos += 4;
            }
            if (0L != this.cpuTime) {
                buf[pos] = 3;
                buf[++pos] = 1;
                DSRConvert.long2EightByte(this.cpuTime, buf, ++pos);
                pos += 8;
            }
            if (0L != this.respTime) {
                buf[pos] = 10;
                buf[++pos] = 1;
                DSRConvert.long2EightByte(this.respTime, buf, ++pos);
                pos += 8;
            }
            if (0L != this.extTime) {
                buf[pos] = 15;
                buf[++pos] = 1;
                DSRConvert.long2EightByte(this.extTime, buf, ++pos);
                pos += 8;
            }
            if (0L != this.allocMem) {
                buf[pos] = 7;
                buf[++pos] = 1;
                DSRConvert.long2EightByte(this.allocMem, buf, ++pos);
                pos += 8;
            }
            if (0L != this.dbTime) {
                buf[pos] = 31;
                buf[++pos] = 1;
                DSRConvert.long2EightByte(this.dbTime, buf, ++pos);
                pos += 8;
            }
            if (0L != this.sentBytes) {
                buf[pos] = 23;
                buf[++pos] = 1;
                DSRConvert.long2EightByte(this.sentBytes, buf, ++pos);
                pos += 8;
            }
            if (0L != this.receivedBytes) {
                buf[pos] = 21;
                buf[++pos] = 1;
                DSRConvert.long2EightByte(this.receivedBytes, buf, ++pos);
                pos += 8;
            }
            if (this.transId != null) {
                if (this.transIdBytes == null) {
                    this.transIdBytes = this.transId.getBytes("UTF-8");
                }
                buf[pos] = 13;
                buf[++pos] = 2;
                DSRConvert.int2TwoByte(this.transIdBytes.length, buf, ++pos);
                System.arraycopy(this.transIdBytes, 0, buf, pos += 2, this.transIdBytes.length);
                pos += this.transIdBytes.length;
            }
            if (this.action != null) {
                if (this.actionBytes == null) {
                    this.actionBytes = this.action.getBytes("UTF-8");
                }
                buf[pos] = 0;
                buf[++pos] = 2;
                DSRConvert.int2TwoByte(this.actionBytes.length, buf, ++pos);
                System.arraycopy(this.actionBytes, 0, buf, pos += 2, this.actionBytes.length);
                pos += this.actionBytes.length;
            }
            if (this.userId != null) {
                if (this.userIdBytes == null) {
                    this.userIdBytes = this.userId.getBytes("UTF-8");
                }
                buf[pos] = 14;
                buf[++pos] = 2;
                DSRConvert.int2TwoByte(this.userIdBytes.length, buf, ++pos);
                System.arraycopy(this.userIdBytes, 0, buf, pos += 2, this.userIdBytes.length);
                pos += this.userIdBytes.length;
            }
            if (this.addInfo != null) {
                if (this.addInfoBytes == null) {
                    this.addInfoBytes = this.addInfo.getBytes("UTF-8");
                }
                buf[pos] = 2;
                buf[++pos] = 2;
                DSRConvert.int2TwoByte(this.addInfoBytes.length, buf, ++pos);
                System.arraycopy(this.addInfoBytes, 0, buf, pos += 2, this.addInfoBytes.length);
                pos += this.addInfoBytes.length;
            }
            DSRConvert.int2TwoByte(pos - offset, buf, offset + 4);
        }
        catch (Exception exception) {
            return 0;
        }
        return pos - offset;
    }

    public int getKeyValueFilds(byte[] buf, int offset) {
        int pos = offset;
        if (this.sessionSize != 0) {
            pos += this.fillKeyValueFieldInt32(buf, pos, this.sessionSize, DSRConstants.keyValueRecord_sessionSizeKey);
        }
        if (this.dbCalls > 0) {
            pos += this.fillKeyValueFieldInt32(buf, pos, this.dbCalls, DSRConstants.keyValueRecord_dbCallsKey);
        }
        if (this.dbIO > 0L) {
            pos += this.fillKeyValueFieldInt64(buf, pos, this.dbIO, DSRConstants.keyValueRecord_dbIOKey);
        }
        return pos - offset;
    }

    private int fillKeyValueFieldInt32(byte[] buf, int offset, int value, byte[] key) {
        int pos = offset;
        try {
            if (value != 0) {
                DSRConvert.int2FourByte(123456789, buf, pos);
                buf[pos += 6] = 100;
                buf[++pos] = 100;
                System.arraycopy(key, 0, buf, ++pos, 4);
                pos += 4;
                buf[++pos] = 0;
                DSRConvert.int2FourByte(value, buf, ++pos);
                pos += 4;
            }
            DSRConvert.int2TwoByte(pos - offset, buf, offset + 4);
        }
        catch (Exception exception) {
            return 0;
        }
        return pos - offset;
    }

    private int fillKeyValueFieldInt64(byte[] buf, int offset, long value, byte[] key) {
        int pos = offset;
        try {
            if (value != 0L) {
                DSRConvert.int2FourByte(123456789, buf, pos);
                buf[pos += 6] = 100;
                buf[++pos] = 100;
                System.arraycopy(key, 0, buf, ++pos, 4);
                pos += 4;
                buf[++pos] = 1;
                DSRConvert.long2EightByte(value, buf, ++pos);
                pos += 8;
            }
            DSRConvert.int2TwoByte(pos - offset, buf, offset + 4);
        }
        catch (Exception exception) {
            return 0;
        }
        return pos - offset;
    }

    public long getExtTime() {
        return this.extTime;
    }

    public void setExtTime(long extTime) {
        this.extTime = extTime;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setActionType(int actionType) {
        this.actionType = actionType;
    }

    public void setAddInfo(String addInfo) {
        this.addInfo = addInfo;
    }

    public void setAllocMem(long allocMem) {
        this.allocMem = allocMem;
    }

    public void setCpuTime(long cpuTime) {
        this.cpuTime = cpuTime;
    }

    public void setDbTime(long dbTime) {
        this.dbTime = dbTime;
    }

    public void setReceivedBytes(long receivedBytes) {
        this.receivedBytes = receivedBytes;
    }

    public void setRespTime(long respTime) {
        this.respTime = respTime;
    }

    public void setSentBytes(long sentBytes) {
        this.sentBytes = sentBytes;
    }

    public void setServiceType(int serviceType) {
        this.serviceType = serviceType;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setTransId(String transId) {
        this.transId = transId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    @Override
    public int getDbCalls() {
        return this.dbCalls;
    }

    public void setDbCalls(int dbCalls) {
        this.dbCalls = dbCalls;
    }

    @Override
    public long getDbIO() {
        return this.dbIO;
    }

    public void setDbIO(long dbIO) {
        this.dbIO = dbIO;
    }

    @Override
    public int getSessionSize() {
        return this.sessionSize;
    }

    public void setSessionSize(int sessionSize) {
        this.sessionSize = sessionSize;
    }
}

