/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.destinations.impl;

import com.sap.security.destinations.ConfigurationException;
import com.sap.security.destinations.http.AuthenticationSpi;
import com.sap.security.destinations.http.HTTPDestination;
import com.sap.security.destinations.impl.AbstractDestinationImpl;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class HTTPDestinationImpl
extends AbstractDestinationImpl
implements HTTPDestination {
    private URL url = null;
    private AuthenticationSpi auth = null;
    private HttpURLConnection state = null;
    private HashSet<String> cookies = new HashSet();

    public HTTPDestinationImpl(Properties configuration) throws ConfigurationException {
        super(configuration);
        if (!configuration.containsKey("URL")) {
            throw new ConfigurationException("Destination " + this.getName() + " is not configured with URL!", null);
        }
        try {
            this.url = new URL(this.getAttribute("URL"));
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("Destination " + this.getName() + " is configured with malformed URL!", (Throwable)e);
        }
        AuthenticationSpi spi = this.engineGetAuthenticationSpi(this.getAuthenticationType());
        if (!(spi instanceof AuthenticationSpi)) {
            throw new ConfigurationException("Authentication " + this.getAuthenticationType() + " is not supported!", null);
        }
        this.auth = spi;
    }

    public void close() {
        this.state = null;
        this.cookies.clear();
    }

    @Override
    public void setPath(String path) throws MalformedURLException {
        String file = path;
        if (!file.startsWith("/")) {
            file = "/" + file;
        }
        if (this.url.getQuery() != null) {
            file = String.valueOf(file) + this.url.getQuery();
        }
        this.url = new URL(this.url.getProtocol(), this.url.getHost(), this.url.getPort(), file);
    }

    @Override
    public void setQuery(String query) throws MalformedURLException {
        String file = this.url.getPath();
        if (query != null) {
            file = query.startsWith("?") ? String.valueOf(file) + query : String.valueOf(file) + "?" + query;
        }
        this.url = new URL(this.url.getProtocol(), this.url.getHost(), this.url.getPort(), file);
    }

    @Override
    public String getUrl() {
        return this.url.toExternalForm();
    }

    @Override
    public HttpURLConnection getURLConnection() throws ConfigurationException, IOException {
        if (this.state != null) {
            this.readSessionCookies(this.state, this.cookies);
        }
        try {
            HttpURLConnection http = (HttpURLConnection)new URL(this.getUrl()).openConnection();
            for (String cookie : this.cookies) {
                http.addRequestProperty("Cookie", cookie);
            }
            this.auth.authenticate(http, this.getConfiguration());
            this.state = http;
            return http;
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("Unable to obtain connection to destination!", (Throwable)e);
        }
    }

    private final void readSessionCookies(HttpURLConnection session, Collection<String> sessionCookies) {
        for (Map.Entry<String, List<String>> entry : session.getHeaderFields().entrySet()) {
            List<String> cookies;
            if (!"Set-Cookie".equalsIgnoreCase(entry.getKey()) && !"Cookie".equalsIgnoreCase(entry.getKey()) || (cookies = entry.getValue()) == null) continue;
            for (String cookie : cookies) {
                int index = cookie.indexOf(59);
                if (index >= 0) {
                    cookie = cookie.substring(0, index);
                }
                sessionCookies.add(cookie);
            }
        }
    }

    protected Collection<String> engineGetAuthenticationTypes() {
        HashSet<String> types = new HashSet<String>();
        ServiceTracker tracker = this.getTracker();
        if (tracker != null) {
            Object[] objectArray = tracker.getServices();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object service = objectArray[n2];
                AuthenticationSpi spi = (AuthenticationSpi)service;
                types.add(spi.getType());
                ++n2;
            }
        }
        tracker.close();
        return types;
    }

    protected AuthenticationSpi engineGetAuthenticationSpi(String authenticationType) {
        ServiceTracker tracker = this.getTracker();
        if (tracker != null) {
            Object[] objectArray = tracker.getServices();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object service = objectArray[n2];
                AuthenticationSpi spi = (AuthenticationSpi)service;
                if (authenticationType.equals(spi.getType())) {
                    tracker.close();
                    return spi;
                }
                ++n2;
            }
            tracker.close();
        }
        return null;
    }

    private ServiceTracker getTracker() {
        BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        ServiceTracker tracker = new ServiceTracker(context, AuthenticationSpi.class.getName(), null);
        tracker.open();
        return tracker;
    }
}

