/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.destinations.ljs;

import com.sap.security.auth.service.UserSession;
import com.sap.security.destinations.ConfigurationException;
import com.sap.security.destinations.Destination;
import com.sap.security.destinations.DestinationConfiguration;
import com.sap.security.destinations.DestinationService;
import com.sap.security.destinations.impl.HTTPDestinationImpl;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

class DestinationServiceImpl
implements DestinationService {
    private static final Logger LOG = Logger.getLogger(DestinationServiceImpl.class.getName());
    private static final String SESSION_DESTINATION_KEY = "com.sap.security.destination.";
    private DestinationConfiguration configuration;

    DestinationServiceImpl() {
    }

    public Destination getDestination(String name) throws ConfigurationException {
        Destination destination = this.getDestinationFromSession(name);
        if (destination == null) {
            if (this.configuration != null) {
                Properties c = this.configuration.getDestinationConfiguration(name);
                if (c != null) {
                    destination = new HTTPDestinationImpl(c);
                    this.setDestinationInSession(name, destination);
                }
            } else {
                LOG.log(Level.SEVERE, "DestinationConfiguration is not available. DestinationService cannot be created!");
                throw new ConfigurationException("DestinationConfiguration is not available!", null);
            }
        }
        return destination;
    }

    private Destination getDestinationFromSession(String name) {
        UserSession session = UserSession.getInstance();
        if (session != null) {
            return (Destination)session.getAttribute(SESSION_DESTINATION_KEY + name);
        }
        return null;
    }

    private void setDestinationInSession(String name, Destination destination) {
        UserSession session = UserSession.getInstance();
        if (session != null) {
            session.setAttribute(SESSION_DESTINATION_KEY + name, (Object)destination);
        }
    }

    public String getType() {
        return "HTTP";
    }

    public void setConfiguration(DestinationConfiguration configuration) {
        this.configuration = configuration;
    }
}

