/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.resources.filemanagement.client.impl;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.sap.cloud.resources.filemanagement.client.AuthenticationException;
import com.sap.cloud.resources.filemanagement.client.BasicResourceInfo;
import com.sap.cloud.resources.filemanagement.client.ResourceManager;
import com.sap.cloud.resources.filemanagement.client.ResourceNotFoundException;
import com.sap.cloud.resources.filemanagement.client.ResourceOperationException;
import com.sap.cloud.resources.filemanagement.client.UnauthorizedException;
import com.sap.cloud.resources.filemanagement.client.ValidationException;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.FileEntity;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class ResourceManagerImpl
implements ResourceManager {
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final String EXECUTION_FAILED_MESSAGE = "Command execution failed";
    static final String RESPONSE_CANNOT_BE_PARSED = "Cannot parse response from server";
    private static final Logger LOGGER = Logger.getLogger(ResourceManagerImpl.class);
    private static final String RESOURCE_MANAGER_URL_PATTERN = "/resources/v1/accounts/{0}/files/";
    private HttpClient httpClient;
    private String resourceManagerURL;

    public ResourceManagerImpl(HttpClient httpClient, URL landscapeURL, String account) throws MalformedURLException {
        this.httpClient = httpClient;
        this.resourceManagerURL = this.getResourceManagerURL(landscapeURL, account);
    }

    @Override
    public void upload(String name, File file) throws ValidationException, ResourceOperationException, UnauthorizedException {
        String url = this.resourceManagerURL + name;
        HttpPut request = new HttpPut(url);
        request.addHeader(CONTENT_TYPE, APPLICATION_OCTET_STREAM);
        request.setEntity((HttpEntity)new FileEntity(file, null));
        this.execute((HttpUriRequest)request, 204);
    }

    @Override
    public void delete(String name) throws ResourceNotFoundException, ResourceOperationException, UnauthorizedException {
        String url = this.resourceManagerURL + name;
        HttpDelete request = new HttpDelete(url);
        HttpResponse response = this.execute((HttpUriRequest)request, 204, 404);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 404) {
            throw new ResourceNotFoundException("Requested resource was not found");
        }
    }

    @Override
    public BasicResourceInfo[] list() throws ResourceOperationException, UnauthorizedException {
        HttpGet request = new HttpGet(this.resourceManagerURL);
        HttpResponse response = this.execute((HttpUriRequest)request, 200, 404);
        try {
            return this.readListResponse(response);
        }
        catch (IOException e) {
            throw new ResourceOperationException(RESPONSE_CANNOT_BE_PARSED, e);
        }
        catch (JsonParseException e) {
            throw new ResourceOperationException(RESPONSE_CANNOT_BE_PARSED, e);
        }
    }

    @Override
    public boolean exists(String name) throws ResourceOperationException {
        String url = this.resourceManagerURL + name;
        HttpHead request = new HttpHead(url);
        HttpResponse response = this.execute((HttpUriRequest)request, 204, 404);
        int statusCode = response.getStatusLine().getStatusCode();
        return statusCode == 204;
    }

    private HttpResponse execute(HttpUriRequest request, int ... validStatusCodes) throws ResourceOperationException, UnauthorizedException, AuthenticationException {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Executing " + request.getRequestLine()));
            }
            HttpResponse response = this.httpClient.execute(request);
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            String reasonPhrase = statusLine.getReasonPhrase();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Result: " + statusLine));
            }
            if (statusCode == 401) {
                throw new AuthenticationException(reasonPhrase);
            }
            if (statusCode == 403) {
                throw new UnauthorizedException(this.readResponseBodyAsString(response));
            }
            boolean valid = true;
            if (validStatusCodes != null) {
                valid = false;
                for (int validStatusCode : validStatusCodes) {
                    if (statusCode != validStatusCode) continue;
                    valid = true;
                    break;
                }
            }
            if (!valid) {
                throw new ResourceOperationException("Command execution failed: " + reasonPhrase);
            }
            return response;
        }
        catch (IOException e) {
            throw new ResourceOperationException(EXECUTION_FAILED_MESSAGE, e);
        }
    }

    private String getResourceManagerURL(URL landscapeURL, String account) throws MalformedURLException {
        URL url = new URL(landscapeURL.getProtocol(), "deployment." + landscapeURL.getHost(), landscapeURL.getPort(), MessageFormat.format(RESOURCE_MANAGER_URL_PATTERN, account));
        return url.toExternalForm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readResponseBodyAsString(HttpResponse response) {
        HttpEntity entity = response.getEntity();
        try {
            if (entity != null) {
                String string = EntityUtils.toString((HttpEntity)entity);
                return string;
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"An error occurred while parsing the response body as string", (Throwable)e);
        }
        finally {
            try {
                EntityUtils.consume((HttpEntity)entity);
            }
            catch (IOException e) {
                LOGGER.warn((Object)"An error occurred while consuming the http response entity", (Throwable)e);
            }
        }
        return RESPONSE_CANNOT_BE_PARSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BasicResourceInfo[] readListResponse(HttpResponse response) throws IOException, JsonParseException {
        HttpEntity entity = response.getEntity();
        int statusCode = response.getStatusLine().getStatusCode();
        BasicResourceInfo[] list = null;
        if (entity != null && statusCode == 200) {
            InputStreamReader reader = null;
            try {
                reader = new InputStreamReader(entity.getContent(), "UTF-8");
                list = (BasicResourceInfo[])new Gson().fromJson((Reader)reader, BasicResourceInfo[].class);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        if (list == null) {
            list = new BasicResourceInfo[]{};
        }
        return list;
    }
}

