/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.runtime.kotyo.mail.client.local.routing;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.URLName;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalTransport
extends Transport {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalTransport.class);
    File targetDirectory = this.getTargetDirectory();

    public LocalTransport(Session smtpSession, URLName urlName) {
        super(smtpSession, urlName);
    }

    private File getTargetDirectory() {
        String serverConfigHome = System.getProperty("server.config.home");
        File baseFolder = null;
        baseFolder = serverConfigHome != null && new File(serverConfigHome).isDirectory() ? new File(serverConfigHome) : new File(".");
        return new File(baseFolder, "work/mailservice");
    }

    public void connect() throws MessagingException {
    }

    public void connect(String host, int port, String username, String password) throws MessagingException {
    }

    public void connect(String host, String username, String password) throws MessagingException {
    }

    public void close() {
    }

    public void sendMessage(Message message, Address[] addresses) throws MessagingException {
        FileOutputStream outStream = null;
        try {
            File file = new File(this.createTargetDirectory(), "mail_" + System.currentTimeMillis() + ".msg");
            LOGGER.info("Saving mail '" + message.getSubject() + "' to '" + file + "'");
            outStream = new FileOutputStream(file);
            message.writeTo((OutputStream)outStream);
        }
        catch (Exception e) {
            try {
                LOGGER.error("Could not save mail to local file.", (Throwable)e);
                throw new MessagingException("Could not save mail to local file.", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)outStream);
    }

    File createTargetDirectory() {
        if (!this.targetDirectory.isDirectory() && !this.targetDirectory.mkdirs()) {
            throw new IllegalStateException("Could not create directory '" + this.targetDirectory + "'");
        }
        return this.targetDirectory;
    }
}

