/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sshtunnel.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sap.cloud.sshtunnel.api.SDKConnectionInfo;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

public class SSHAdminClient {
    private static final String SSHTUNNEL_URL_BY_ID = "https://sshtunnel.%s/infra/tunneling/v1/connection/?account=%s&vmid=%s";
    private static final String SSHTUNNEL_URL_BY_NAME = "https://sshtunnel.%s/infra/tunneling/v1/connection/?account=%s&vmName=%s";
    private String account;
    private String landscapeHost;
    private HttpClient httpClient;

    private SSHAdminClient(String account, String landscapeHost, HttpClient httpClient) {
        this.account = account;
        this.landscapeHost = landscapeHost;
        this.httpClient = httpClient;
    }

    public static SSHAdminClient getInstance(String account, String landscapeHost, HttpClient httpClient) {
        return new SSHAdminClient(account, landscapeHost, httpClient);
    }

    public SDKConnectionInfo getConnectionInfoById(String vmId) throws Exception {
        URI target = new URI(String.format(SSHTUNNEL_URL_BY_ID, this.landscapeHost, this.account, vmId));
        HttpGet get = new HttpGet(target);
        HttpResponse response = this.httpClient.execute((HttpUriRequest)get);
        this.checkResponseStatus("ID", vmId, response);
        return this.getConnectionInfo(response);
    }

    public SDKConnectionInfo getConnectionInfoByName(String vmName) throws Exception {
        URI target = new URI(String.format(SSHTUNNEL_URL_BY_NAME, this.landscapeHost, this.account, vmName));
        HttpGet get = new HttpGet(target);
        HttpResponse response = this.httpClient.execute((HttpUriRequest)get);
        this.checkResponseStatus("name", vmName, response);
        return this.getConnectionInfo(response);
    }

    private SDKConnectionInfo getConnectionInfo(HttpResponse response) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(response.getEntity().getContent(), "UTF-8");){
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.setDateFormat("M/d/yy hh:mm a");
            Gson gson = gsonBuilder.create();
            SDKConnectionInfo sDKConnectionInfo = (SDKConnectionInfo)gson.fromJson((Reader)reader, SDKConnectionInfo.class);
            return sDKConnectionInfo;
        }
    }

    private void checkResponseStatus(String nameOrIdKey, String nameOrIdKeyValue, HttpResponse response) {
        StatusLine statusLine = response.getStatusLine();
        if (statusLine.getStatusCode() == 404) {
            throw new CommandException(String.format("Virtual machine with %s %s does not exist. Provide the correct %s.", nameOrIdKey, nameOrIdKeyValue, nameOrIdKey));
        }
        if (statusLine.getStatusCode() == 401) {
            throw new CommandException("Authorization failed. Please check your user name and password");
        }
        if (statusLine.getStatusCode() == 400) {
            throw new CommandException("One of the parameters --vm-id or --vm-name must be specified.");
        }
        if (statusLine.getStatusCode() != 200) {
            throw new CommandException("Cannot establish connection. Please try again.");
        }
    }
}

