/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sshtunnel.client.proxyagent;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class DaemonProcessController {
    private static Logger logger = Logger.getLogger(DaemonProcessController.class);
    private List<String> cmd;
    protected Process process;
    protected Future<Integer> exitValueFuture;
    protected Integer exitValue;

    public DaemonProcessController(List<String> cmd) {
        this.cmd = cmd;
    }

    public void start() throws IOException {
        logger.debug((Object)"Creating background process with command line: ");
        logger.debug(this.cmd);
        ProcessBuilder pb = new ProcessBuilder(this.cmd);
        this.process = pb.start();
        Callable<Integer> exitValueCallable = new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                int exitValue = DaemonProcessController.this.process.waitFor();
                return exitValue;
            }
        };
        ExecutorService executorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread result = new Thread(r);
                result.setDaemon(true);
                return result;
            }
        });
        this.exitValueFuture = executorService.submit(exitValueCallable);
    }

    public Integer getExitValue() {
        return this.exitValue;
    }

    public void destroyProcess() {
        this.process.destroy();
    }

    public void waitForOutput(String eyecatch, int timeoutMillis) {
        block6: {
            try {
                BufferedReader reader = this.getProcessInputStream();
                Calendar timeoutDate = Calendar.getInstance();
                timeoutDate.add(14, timeoutMillis);
                do {
                    if (this.exitValueFuture.isDone()) {
                        this.exitValue = this.exitValueFuture.get();
                        logger.error((Object)("Background process has terminated unexpectedly with exit value " + this.exitValue));
                        break block6;
                    }
                    String line = null;
                    if (reader.ready()) {
                        line = reader.readLine();
                    }
                    if (line != null && line.contains(eyecatch)) {
                        logger.info((Object)("Received eyecatch " + eyecatch));
                        break block6;
                    }
                    Thread.sleep(1000L);
                } while (!Calendar.getInstance().after(timeoutDate));
                logger.info((Object)("Timeout reached. Did not receive eyecatch " + eyecatch));
                this.checkProcessExitValue(3000L);
            }
            catch (Exception e) {
                logger.error((Object)"Exception while trying to read ready signal", (Throwable)e);
                this.checkProcessExitValue(3000L);
            }
        }
    }

    protected BufferedReader getProcessInputStream() throws UnsupportedEncodingException {
        return new BufferedReader(new InputStreamReader(this.process.getInputStream(), "UTF-8"));
    }

    protected void checkProcessExitValue(long timeoutMillis) {
        if (this.exitValue != null) {
            return;
        }
        try {
            this.exitValue = this.exitValueFuture.get(timeoutMillis, TimeUnit.MILLISECONDS);
            logger.info((Object)("Background process returned exit value " + this.exitValue));
        }
        catch (InterruptedException e) {
            logger.error((Object)"InterruptedException while trying to get background process exit value", (Throwable)e);
        }
        catch (ExecutionException e) {
            logger.error((Object)"ExecutionException while trying to get background process exit value", (Throwable)e);
        }
        catch (TimeoutException e) {
            logger.info((Object)("Background process did not return exit value within " + timeoutMillis + " ms"));
        }
    }

    public String getErrorStreamSnippet(int limit) throws IOException {
        if (this.process == null) {
            return "";
        }
        return this.getStreamSnippet(this.process.getErrorStream(), limit);
    }

    public String getOutputStreamSnippet(int limit) throws IOException {
        if (this.process == null) {
            return "";
        }
        return this.getStreamSnippet(this.process.getInputStream(), limit);
    }

    protected String getStreamSnippet(InputStream inputStream, int limit) throws IOException {
        int r;
        int availBytes;
        if (inputStream.available() == 0) {
            return "";
        }
        long freeMemory = Runtime.getRuntime().freeMemory();
        long thirdPartOfFreeMemory = freeMemory / 3L;
        if ((long)limit > thirdPartOfFreeMemory) {
            logger.warn((Object)("Attempted to get more memory than available: requested '" + limit + "' free '" + freeMemory + "'. Automatically reduced request to '" + thirdPartOfFreeMemory + "'."));
            limit = (int)thirdPartOfFreeMemory;
        }
        StringBuilder sbuff = new StringBuilder();
        byte[] buff = new byte[limit];
        while (sbuff.length() < limit && (availBytes = inputStream.available()) > 0 && (r = inputStream.read(buff)) != -1) {
            String err = new String(buff, 0, r, "UTF-8");
            sbuff.append(err);
        }
        return sbuff.toString();
    }
}

