/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sshtunnel.client.proxyagent;

import com.sap.cloud.sshtunnel.api.ConnectionInfo;
import com.sap.cloud.sshtunnel.client.ProxySettings;
import com.sap.cloud.sshtunnel.client.SSHHTTPSProxy;
import com.sap.cloud.sshtunnel.client.SSHTunnelEndpoint;
import com.sap.cloud.sshtunnel.client.proxyagent.SshTunnelInfo;
import com.sap.cloud.sshtunnel.client.proxyagent.TunnelProcessMBean;
import com.sap.cloud.sshtunnel.client.proxyagent.TunnelTrustManager;
import com.sap.core.connectivity.tunnel.api.TunnelConsumableService;
import com.sap.core.connectivity.tunnel.api.TunnelConsumableServices;
import com.sap.core.connectivity.tunnel.api.TunnelProvidedServices;
import com.sap.core.connectivity.tunnel.api.management.ConnectionFailedException;
import com.sap.core.connectivity.tunnel.api.management.DefaultTunnelConfiguration;
import com.sap.core.connectivity.tunnel.api.management.DirectTunnelOperator;
import com.sap.core.connectivity.tunnel.api.management.PortUnavailableException;
import com.sap.core.connectivity.tunnel.api.management.ProxyProtocol;
import com.sap.core.connectivity.tunnel.api.management.TunnelConfiguration;
import com.sap.core.connectivity.tunnel.api.management.TunnelEndpoint;
import com.sap.core.connectivity.tunnel.api.management.TunnelManagement;
import com.sap.core.connectivity.tunnel.api.management.TunnelStateListener;
import com.sap.core.connectivity.tunnel.client.certificate.PemToKeyCertificateConverter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public class TunnelProcess
implements TunnelProcessMBean {
    private static final String RSA = "RSA";
    private TunnelManagement tm;
    private final Map<String, DirectTunnelOperator> serverId2operator = new HashMap<String, DirectTunnelOperator>();
    private final Map<String, SshTunnelInfo> sshTunnelsInfoMap = new HashMap<String, SshTunnelInfo>();
    protected PemToKeyCertificateConverter converter = new PemToKeyCertificateConverter();

    public TunnelProcess() {
        TunnelConsumableServices.registerService(TunnelConfiguration.class, (TunnelConsumableService)new DefaultTunnelConfiguration());
        this.tm = (TunnelManagement)TunnelProvidedServices.getService(TunnelManagement.class);
    }

    public TunnelManagement getTm() {
        return this.tm;
    }

    public void setTm(TunnelManagement tm) {
        this.tm = tm;
    }

    @Override
    public int openTunnel(final String serverId, int localPort, String landscapeHost, ProxySettings proxySettings, ConnectionInfo info, final boolean closeProcessOnLastTunnelClose) throws ConnectionFailedException, PortUnavailableException {
        SSHTunnelEndpoint endpoint = this.createSSHEndpoint(landscapeHost, proxySettings, info);
        String clientId = this.generateClientId();
        DirectTunnelOperator operator = this.createOperator(endpoint, clientId);
        operator.connect(info.getTunnelId(), info.getRoutingInfo());
        if (localPort > 0) {
            operator.getProxyManagement().startProxy(localPort, info.getTunnelId(), serverId, ProxyProtocol.TCP);
        } else {
            localPort = operator.getProxyManagement().startProxy(info.getTunnelId(), serverId, ProxyProtocol.TCP);
        }
        final int tunnelPort = localPort;
        this.addToOperatorMap(serverId, tunnelPort, operator);
        operator.addListener(new TunnelStateListener(){

            public void tunnelClosed(String tunnelId) {
                TunnelProcess.this.removeLocalPortFromSshTunnelsInfoMap(serverId, tunnelPort);
                TunnelProcess.this.removeFromOperatorMap(serverId, tunnelPort);
                if (closeProcessOnLastTunnelClose && TunnelProcess.this.sshTunnelsInfoMap.isEmpty()) {
                    System.exit(0);
                }
            }
        });
        this.addInfoToSshTunnelsInfoMap(serverId, tunnelPort);
        return tunnelPort;
    }

    private void addToOperatorMap(String serverId, int localPort, DirectTunnelOperator operator) {
        String key = serverId + localPort;
        this.serverId2operator.put(key, operator);
    }

    private void addInfoToSshTunnelsInfoMap(String serverId, int localPort) {
        SshTunnelInfo sshTunnelInfo = this.sshTunnelsInfoMap.get(serverId);
        if (sshTunnelInfo == null) {
            sshTunnelInfo = new SshTunnelInfo();
        }
        sshTunnelInfo.addPort(localPort);
        this.sshTunnelsInfoMap.put(serverId, sshTunnelInfo);
    }

    protected DirectTunnelOperator createOperator(SSHTunnelEndpoint endpoint, String clientId) {
        return this.tm.createDirectTunnelOperator((TunnelEndpoint)endpoint, clientId);
    }

    protected String generateClientId() {
        return UUID.randomUUID().toString();
    }

    protected SSHTunnelEndpoint createSSHEndpoint(String landscapeHost, ProxySettings proxySettings, ConnectionInfo info) {
        SSHTunnelEndpoint endpoint = new SSHTunnelEndpoint();
        endpoint.setNotificationAddress(new InetSocketAddress("connectivitynotification." + landscapeHost, 443));
        endpoint.setTunnelServerAddress(new InetSocketAddress("connectivitytunnel." + landscapeHost, 443));
        endpoint.setSSLContext(this.createSSLContext(info.getCertificate()));
        if (proxySettings != null) {
            endpoint.setHttpsProxy(new SSHHTTPSProxy(new InetSocketAddress(proxySettings.getHost(), proxySettings.getPort()), proxySettings.getUser(), proxySettings.getPassword()));
        }
        return endpoint;
    }

    protected SSLContext createSSLContext(String pem) {
        try {
            X509Certificate cert = this.converter.getCertificateFromPem(pem);
            PrivateKey key = this.converter.getPrivateKeyFromPem(RSA, pem);
            char[] password = this.generateClientId().toCharArray();
            KeyStore keyStore = this.getAndConfigureKeyStoreInstance(cert, key, password);
            SSLContext context = this.getSSLContext();
            KeyManagerFactory kms = this.getKeyManagerFactory();
            kms.init(keyStore, password);
            TrustManager[] trustAll = new TrustManager[]{new TunnelTrustManager()};
            context.init(kms.getKeyManagers(), trustAll, new SecureRandom());
            return context;
        }
        catch (Exception e) {
            throw new RuntimeException("There was an error creating SSL context", e);
        }
    }

    protected KeyStore getAndConfigureKeyStoreInstance(X509Certificate cert, PrivateKey key, char[] password) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, null);
        keyStore.setCertificateEntry("ca", cert);
        keyStore.setKeyEntry("onetime", key, password, new X509Certificate[]{cert});
        return keyStore;
    }

    protected KeyManagerFactory getKeyManagerFactory() throws NoSuchAlgorithmException {
        KeyManagerFactory kms = KeyManagerFactory.getInstance("SunX509");
        return kms;
    }

    protected SSLContext getSSLContext() throws NoSuchAlgorithmException {
        SSLContext context = SSLContext.getInstance("SSL");
        return context;
    }

    @Override
    public void closeTunnel(String serverId) {
        SshTunnelInfo sshTunnelInfo = this.sshTunnelsInfoMap.get(serverId);
        LinkedList<Integer> ports = new LinkedList<Integer>(sshTunnelInfo.getPorts());
        for (Integer port : ports) {
            this.closeTunnel(serverId, port);
        }
    }

    @Override
    public void closeTunnel(int port) {
        Set<String> keySet = this.sshTunnelsInfoMap.keySet();
        for (String key : keySet) {
            SshTunnelInfo sshTunnelInfo = this.sshTunnelsInfoMap.get(key);
            if (!sshTunnelInfo.getPorts().contains(port)) continue;
            this.closeTunnel(key, port);
        }
    }

    @Override
    public void closeTunnel(String serverId, int port) {
        DirectTunnelOperator operator = this.getOperator(serverId, port);
        operator.getProxyManagement().stopProxy(port);
        operator.disconnect();
    }

    private void removeFromOperatorMap(String serverId, int port) {
        String key = serverId + port;
        this.serverId2operator.remove(key);
    }

    private void removeLocalPortFromSshTunnelsInfoMap(String serverId, Integer port) {
        SshTunnelInfo sshTunnelInfo = this.sshTunnelsInfoMap.get(serverId);
        if (sshTunnelInfo != null) {
            sshTunnelInfo.removePort(port);
            this.removeInfoIfAllTunnelsAreClosed(serverId, sshTunnelInfo);
        }
    }

    private void removeInfoIfAllTunnelsAreClosed(String serverId, SshTunnelInfo sshTunnelInfo) {
        List<Integer> ports = sshTunnelInfo.getPorts();
        if (ports == null || ports.isEmpty()) {
            this.sshTunnelsInfoMap.remove(serverId);
        }
    }

    protected DirectTunnelOperator getOperator(String serverId, int port) {
        String key = serverId + port;
        DirectTunnelOperator operator = this.serverId2operator.get(key);
        if (operator == null) {
            throw new RuntimeException("There are no open tunnels to virtual machine with ID: " + serverId);
        }
        return operator;
    }

    @Override
    public void closeAllTunnels() {
        System.out.println("Close all tunnels");
        LinkedList<String> servers = new LinkedList<String>(this.sshTunnelsInfoMap.keySet());
        for (String serverId : servers) {
            this.closeTunnel(serverId);
        }
    }

    @Override
    public void shutdown() {
        Timer timer = new Timer(true);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                System.exit(0);
            }
        }, 2000L);
    }

    @Override
    public Map<String, List<Integer>> listTunnels() {
        HashMap<String, List<Integer>> tunnelsMap = new HashMap<String, List<Integer>>();
        for (Map.Entry<String, SshTunnelInfo> sshTunnelInfoEntry : this.sshTunnelsInfoMap.entrySet()) {
            tunnelsMap.put(sshTunnelInfoEntry.getKey(), sshTunnelInfoEntry.getValue().getPorts());
        }
        return tunnelsMap;
    }

    @Override
    public String getServerName(String serverId) {
        return this.sshTunnelsInfoMap.get(serverId).getServerName();
    }

    @Override
    public void setServerName(String serverId, String serverName) {
        if (this.sshTunnelsInfoMap.containsKey(serverId)) {
            SshTunnelInfo sshTunnelInfo = this.sshTunnelsInfoMap.get(serverId);
            if (sshTunnelInfo.getServerName() == null) {
                sshTunnelInfo.setServerName(serverName);
            }
        } else {
            SshTunnelInfo sshTunnelInfo = new SshTunnelInfo(serverName);
            this.sshTunnelsInfoMap.put(serverId, sshTunnelInfo);
        }
    }
}

