/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sshtunnel.client.proxyagent;

import com.sap.cloud.sshtunnel.api.ConnectionInfo;
import com.sap.cloud.sshtunnel.client.ProxySettings;
import com.sap.cloud.sshtunnel.client.proxyagent.DaemonProcessController;
import com.sap.cloud.sshtunnel.client.proxyagent.TunnelProcessMBean;
import com.sap.cloud.sshtunnel.client.proxyagent.TunnelProcessMain;
import com.sap.core.connectivity.tunnel.api.management.ConnectionFailedException;
import com.sap.core.connectivity.tunnel.api.management.PortUnavailableException;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class TunnelProcessClient {
    private static final String JMX_PORT = "2020";
    protected TunnelProcessMBean proxyAgentMBean;
    protected DaemonProcessController proxyProcess;

    public int openTunnel(String serverId, int port, String landscapeHost, ProxySettings proxySettings, ConnectionInfo info) throws IOException, ConnectionFailedException, PortUnavailableException {
        TunnelProcessMBean pa = this.getProxyAgentMBean();
        return pa.openTunnel(serverId, port, landscapeHost, proxySettings, info, true);
    }

    public void closeTunnel(String vmid) throws IOException {
        this.checkIfTunnelProcessIsRunning();
        TunnelProcessMBean pa = this.getProxyAgentMBean();
        pa.closeTunnel(vmid);
    }

    public void closeTunnel(int port) throws IOException {
        this.checkIfTunnelProcessIsRunning();
        TunnelProcessMBean pa = this.getProxyAgentMBean();
        pa.closeTunnel(port);
    }

    public void closeTunnel(String serverId, int port) throws IOException {
        this.checkIfTunnelProcessIsRunning();
        TunnelProcessMBean pa = this.getProxyAgentMBean();
        pa.closeTunnel(serverId, port);
    }

    public void closeAllTunnels() throws IOException {
        this.checkIfTunnelProcessIsRunning();
        TunnelProcessMBean pa = this.getProxyAgentMBean();
        pa.closeAllTunnels();
    }

    public Map<String, List<Integer>> listTunnels() throws IOException {
        if (!this.isTunnelProcessRunning()) {
            return Collections.emptyMap();
        }
        TunnelProcessMBean pa = this.getProxyAgentMBean();
        return pa.listTunnels();
    }

    public String getServerName(String serverId) throws IOException {
        TunnelProcessMBean pa = this.getProxyAgentMBean();
        return pa.getServerName(serverId);
    }

    public void setServerName(String serverId, String serverName) throws IOException {
        TunnelProcessMBean pa = this.getProxyAgentMBean();
        pa.setServerName(serverId, serverName);
    }

    protected TunnelProcessMBean getProxyAgentMBean() throws IOException {
        if (this.proxyAgentMBean == null) {
            this.proxyAgentMBean = this.connectToProxyAgent();
        }
        return this.proxyAgentMBean;
    }

    private void checkIfTunnelProcessIsRunning() throws IOException {
        if (!this.isTunnelProcessRunning()) {
            throw new CommandException("Cannot close tunnel because tunnel process is not running");
        }
    }

    protected boolean isTunnelProcessRunning() throws IOException {
        try {
            Socket s = new Socket("127.0.0.1", 2020);
            s.close();
            return true;
        }
        catch (ConnectException e) {
            if (this.proxyProcess != null) {
                this.proxyProcess.destroyProcess();
            }
            return false;
        }
    }

    protected TunnelProcessMBean connectToProxyAgent() throws IOException {
        try {
            if (!this.isTunnelProcessRunning()) {
                this.startProxyAgent();
            }
            JMXConnector con = JMXConnectorFactory.connect(new JMXServiceURL("service:jmx:rmi:///jndi/rmi://127.0.0.1:2020/jmxrmi"), null);
            MBeanServerConnection mbeanConn = con.getMBeanServerConnection();
            ObjectName mbeanName = new ObjectName("com.sap.cloud.sshtunnel:type=ProxyAgent");
            TunnelProcessMBean mbeanProxy = MBeanServerInvocationHandler.newProxyInstance(mbeanConn, mbeanName, TunnelProcessMBean.class, true);
            return mbeanProxy;
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Internal error", e);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Internal error", e);
        }
    }

    private void startProxyAgent() throws IOException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("java");
        cmd.add("-classpath");
        cmd.add(System.getProperty("java.class.path"));
        cmd.add(TunnelProcessMain.class.getName());
        cmd.add(JMX_PORT);
        this.proxyProcess = new DaemonProcessController(cmd);
        this.proxyProcess.start();
        this.proxyProcess.waitForOutput(TunnelProcessMBean.MBEAN_STARTED, 20000);
    }
}

