/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sshtunnel.client.proxyagent;

import com.sap.cloud.sshtunnel.client.proxyagent.TunnelProcess;
import com.sap.cloud.sshtunnel.client.proxyagent.TunnelProcessMBean;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.rmi.registry.LocateRegistry;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

public class TunnelProcessMain {
    public static void main(String[] args) {
        try {
            int port = Integer.parseInt(args[0]);
            LocateRegistry.createRegistry(port);
            MBeanServer mbs = MBeanServerFactory.createMBeanServer();
            mbs.registerMBean(new TunnelProcess(), new ObjectName("com.sap.cloud.sshtunnel:type=ProxyAgent"));
            JMXServiceURL jmxUrl = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:" + port + "/jmxrmi");
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("java.rmi.server.hostname", "localhost");
            JMXConnectorServer connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(jmxUrl, env, mbs);
            connectorServer.start();
            System.out.println(TunnelProcessMBean.MBEAN_STARTED);
            System.setOut(new PrintStream((OutputStream)new FileOutputStream("tunnelprocess.out"), false, "UTF-8"));
            System.out.println("stdout redirection done");
            System.out.flush();
            System.setErr(new PrintStream((OutputStream)new FileOutputStream("tunnelprocess.err"), false, "UTF-8"));
            System.err.println("stderr redirection done");
            Thread.sleep(Long.MAX_VALUE);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

