/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sshtunnel.cmd;

import com.beust.jcommander.Parameter;
import com.sap.cloud.sshtunnel.api.SDKConnectionInfo;
import com.sap.cloud.sshtunnel.client.ProxySettings;
import com.sap.cloud.sshtunnel.client.SSHAdminClient;
import com.sap.cloud.sshtunnel.client.proxyagent.TunnelProcessClient;
import com.sap.core.utils.security.logon.BasicAuthHttpClientProvider;
import com.sap.jpaas.infrastructure.console.command.RemoteCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import com.sap.jpaas.infrastructure.console.exception.HelpException;
import com.sap.jpaas.infrastructure.console.util.DumpHelper;
import com.sap.jpaas.infrastructure.console.validator.AccountValidator;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import org.apache.http.client.HttpClient;
import org.apache.log4j.Logger;

public abstract class BaseConsoleCommand
extends RemoteCommand {
    protected static final Logger LOGGER = Logger.getLogger(BaseConsoleCommand.class);
    @Parameter(names={"-i", "--vm-id"}, description="The ID of the virtual machine")
    protected String vmId;
    @Parameter(names={"-n", "--vm-name"}, description="The name of the virtual machine")
    protected String vmName;
    @Parameter(names={"-a", "-account", "--account"}, description="Name of the account for which you provide user and password", validateWith=AccountValidator.class)
    protected String account;
    protected ProxySettings proxySettings;
    protected final TunnelProcessClient tunnelClient = new TunnelProcessClient();

    public void init() throws CommandException {
        this.superInit();
        if (this.account == null) {
            throw new CommandException("The subaccount parameter is mandatory");
        }
        try {
            String proxyHost = this.getProxyHost();
            if (proxyHost != null) {
                this.proxySettings = this.createProxySettings(proxyHost);
            }
        }
        catch (CommandException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CommandException(e.getMessage(), (Throwable)e, 215);
        }
    }

    protected ProxySettings createProxySettings(String proxyHost) {
        return new ProxySettings(proxyHost, Integer.parseInt(this.getProxyPort()), this.getProxyUser(), this.getProxyPassword());
    }

    protected void superInit() {
        super.initWithNoPasswordCheck();
    }

    public void cleanup() throws CommandException {
    }

    protected void checkParameters() {
        if (this.vmId == null && this.vmName == null) {
            throw new HelpException(String.format("Missing required parameter: [%s] or [%s]", "--vm-id", "--vm-name"));
        }
        if (this.vmId != null && this.vmName != null) {
            throw new HelpException("Only one of the parameters --vm-id or --vm-name must be specified.");
        }
    }

    protected void dumpParameters(String operation) {
        ArrayList argsList = new ArrayList();
        Collections.addAll(argsList, "virtual machine ID", this.vmId, "virtual machine name", this.vmName);
        DumpHelper.dumpOperationList((String)operation, (Object[])argsList.toArray());
    }

    protected SDKConnectionInfo getConnectionInfoById(HttpClient httpClient, String vmId) throws Exception {
        SSHAdminClient sshAdminClient = this.getSSHAdminClientInstance(httpClient);
        return sshAdminClient.getConnectionInfoById(vmId);
    }

    protected SDKConnectionInfo getConnectionInfoByName(HttpClient httpClient, String vmName) throws Exception {
        SSHAdminClient sshAdminClient = this.getSSHAdminClientInstance(httpClient);
        return sshAdminClient.getConnectionInfoByName(vmName);
    }

    protected SSHAdminClient getSSHAdminClientInstance(HttpClient client) throws MalformedURLException {
        URL hostURL = new URL(this.host);
        SSHAdminClient sshAdminClient = SSHAdminClient.getInstance(this.account, hostURL.getHost(), client);
        return sshAdminClient;
    }

    protected String getProxyHost() {
        return System.getProperty("https.proxyHost");
    }

    private String getProxyPort() {
        return System.getProperty("https.proxyPort");
    }

    private String getProxyUser() {
        return System.getProperty("https.proxyUser");
    }

    private String getProxyPassword() {
        return System.getProperty("https.proxyPassword");
    }

    protected HttpClient buildHttpClient() {
        Properties httpClientProperties = new Properties();
        httpClientProperties.setProperty("URL", this.getHost());
        httpClientProperties.setProperty("User", this.getUser());
        httpClientProperties.setProperty("Password", this.getPassword());
        return BasicAuthHttpClientProvider.createHttpClient((Properties)httpClientProperties);
    }
}

