/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sshtunnel.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.cloud.sshtunnel.api.SDKConnectionInfo;
import com.sap.cloud.sshtunnel.client.proxyagent.TunnelProcessClient;
import com.sap.cloud.sshtunnel.cmd.BaseConsoleCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import org.apache.http.client.HttpClient;

@Parameters(commandDescription="Closes the SSH tunnel to the specified virtual machine. If no virtual machine ID is specified, closes all tunnels.")
public class CloseSSHTunnelCommand
extends BaseConsoleCommand {
    @Parameter(names={"-r", "--port"}, description="The port on which you want to close the SSH tunnel - optional parameter")
    protected int port;
    protected final TunnelProcessClient tunnelClient = new TunnelProcessClient();
    private HttpClient httpClient;

    public String getName() {
        return "close-ssh-tunnel";
    }

    public String getGroup() {
        return "virtual machines";
    }

    @Override
    public void init() throws CommandException {
        try {
            if (this.vmId == null && this.vmName != null) {
                super.init();
            } else {
                String proxyHost = this.getProxyHost();
                if (proxyHost != null) {
                    this.proxySettings = this.createProxySettings(proxyHost);
                }
            }
        }
        catch (CommandException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CommandException(e.getMessage(), (Throwable)e, 215);
        }
    }

    public void run() {
        this.dumpParameters("Close tunnel");
        try {
            if (this.vmId == null && this.vmName != null) {
                this.httpClient = this.buildHttpClient();
                SDKConnectionInfo connectionInfoByName = this.getConnectionInfoByName(this.httpClient, this.vmName);
                this.vmId = connectionInfoByName.getVmId();
            }
            if (this.vmId != null && this.port != 0) {
                System.out.println("Closing tunnel to virtual machine. on: " + this.port);
                this.getTunnelClient().closeTunnel(this.vmId, this.port);
            } else if (this.vmId != null) {
                if (this.vmName != null) {
                    System.out.println("Closing tunnel to virtual machine.: " + this.vmName);
                } else {
                    System.out.println("Closing tunnel to virtual machine.: " + this.vmId);
                }
                this.getTunnelClient().closeTunnel(this.vmId);
            } else if (this.port != 0) {
                System.out.println("Closing tunnel to virtual machine. on: " + this.port);
                this.getTunnelClient().closeTunnel(this.port);
            } else {
                System.out.println("Closing all tunnels.");
                this.getTunnelClient().closeAllTunnels();
            }
        }
        catch (Exception e) {
            throw new CommandException(e.getMessage());
        }
    }

    protected TunnelProcessClient getTunnelClient() {
        return this.tunnelClient;
    }
}

