/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sshtunnel.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.cloud.sshtunnel.client.proxyagent.TunnelProcessClient;
import com.sap.cloud.sshtunnel.util.Constants;
import com.sap.jpaas.infrastructure.console.command.ConsoleCommand;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Parameters(commandDescription="Lists SSH tunnels.")
public class ListSSHTunnelsCommand
extends ConsoleCommand {
    @Parameter(names={"-v", "--verbose"}, description="The port on which you want to open the SSH tunnel - optional parameter")
    protected boolean verbose;
    protected final TunnelProcessClient tunnelClient = new TunnelProcessClient();

    public String getName() {
        return "list-ssh-tunnels";
    }

    public String getGroup() {
        return "virtual machines";
    }

    public void run() throws CommandException {
        try {
            Map<String, List<Integer>> tunnels = this.getTunnelClient().listTunnels();
            System.out.println(this.getOutput(tunnels));
        }
        catch (Exception e) {
            throw new CommandException(e.getMessage(), (Throwable)e);
        }
    }

    public Map<String, List<Integer>> runForStructuredOutput() throws CommandException {
        try {
            Map<String, List<Integer>> tunnels = this.getTunnelClient().listTunnels();
            return tunnels;
        }
        catch (Exception e) {
            throw new CommandException(e.getMessage(), (Throwable)e);
        }
    }

    protected String getOutput(Map<String, List<Integer>> tunnels) throws IOException {
        if (tunnels.isEmpty()) {
            return "There are no open tunnels.";
        }
        StringBuilder sshTunnels = this.createSshTunnelsBuilder();
        this.appendTunnels(tunnels, sshTunnels);
        return sshTunnels.toString();
    }

    private StringBuilder createSshTunnelsBuilder() {
        StringBuilder sshTunnels = new StringBuilder(Constants.ALL_OPEN_TUNNELS_TITLE);
        this.addVerboseOutputIfNecessary(sshTunnels, "virtual machine ID");
        sshTunnels.append(Constants.LINE_SEPARATOR);
        return sshTunnels;
    }

    protected void appendTunnels(Map<String, List<Integer>> tunnels, StringBuilder sshTunnels) throws IOException {
        List<String> serverIds = this.getServerIds(tunnels);
        for (String serverId : serverIds) {
            List<Integer> localPortsList = tunnels.get(serverId);
            if (localPortsList == null) continue;
            String serverName = this.getServerName(serverId);
            if (localPortsList.size() != 1) {
                this.appendAllLocalPorts(sshTunnels, serverId, localPortsList, serverName);
                continue;
            }
            this.appendLocalPort(sshTunnels, serverId, localPortsList, serverName);
        }
    }

    protected String getServerName(String serverId) throws IOException {
        return this.getTunnelClient().getServerName(serverId);
    }

    protected List<String> getServerIds(Map<String, List<Integer>> tunnels) {
        List<String> vmids = this.getVmids(tunnels);
        Collections.sort(vmids);
        return vmids;
    }

    protected List<String> getVmids(Map<String, List<Integer>> tunnels) {
        ArrayList<String> vmids = new ArrayList<String>(tunnels.keySet());
        return vmids;
    }

    private void appendAllLocalPorts(StringBuilder sshTunnels, String serverId, List<Integer> localPortsList, String serverName) {
        for (int i = 0; i < localPortsList.size(); ++i) {
            if (i == 0) {
                this.appendLocalPort(sshTunnels, serverId, localPortsList, serverName);
                continue;
            }
            sshTunnels.append(this.getIndentation(serverName.length())).append(":").append(localPortsList.get(i)).append(Constants.LINE_SEPARATOR);
        }
    }

    private void appendLocalPort(StringBuilder sshTunnels, String serverId, List<Integer> localPortsList, String serverName) {
        sshTunnels.append(serverName).append(":").append(localPortsList.get(0));
        this.addVerboseOutputIfNecessary(sshTunnels, serverId);
        sshTunnels.append(Constants.LINE_SEPARATOR);
    }

    private String getIndentation(int length) {
        StringBuilder indentation = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            indentation.append(" ");
        }
        return indentation.toString();
    }

    private void addVerboseOutputIfNecessary(StringBuilder sshTunnels, String serverId) {
        if (this.verbose) {
            sshTunnels.append(" (").append(serverId).append(")");
        }
    }

    protected TunnelProcessClient getTunnelClient() {
        return this.tunnelClient;
    }

    public void cleanup() throws CommandException {
    }

    public void init() throws CommandException {
    }
}

