/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sshtunnel.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.sap.cloud.sshtunnel.api.ConnectionInfo;
import com.sap.cloud.sshtunnel.api.SDKConnectionInfo;
import com.sap.cloud.sshtunnel.client.proxyagent.TunnelProcessClient;
import com.sap.cloud.sshtunnel.cmd.BaseConsoleCommand;
import com.sap.cloud.sshtunnel.util.Constants;
import com.sap.core.connectivity.tunnel.api.management.ConnectionFailedException;
import com.sap.core.connectivity.tunnel.api.management.PortUnavailableException;
import com.sap.jpaas.infrastructure.console.exception.CommandException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.http.client.HttpClient;

@Parameters(commandDescription="Opens a secure tunnel to a specific virtual machine")
public class OpenSSHTunnelCommand
extends BaseConsoleCommand {
    private HttpClient httpClient;
    @Parameter(names={"-r", "--port"}, description="Displays the ID of the virtual machine for each SSH tunnel")
    protected int port;

    public String getName() {
        return "open-ssh-tunnel";
    }

    public String getGroup() {
        return "virtual machines";
    }

    public void run() {
        this.checkParameters();
        this.dumpParameters("Opening a tunnel to the virtual machine.");
        try {
            this.httpClient = this.buildHttpClient();
            String landscapeHost = this.getLandscapeHost();
            SDKConnectionInfo sdkInfo = null;
            if (this.vmId == null) {
                sdkInfo = this.getConnectionInfoByName(this.httpClient, this.vmName);
                this.vmId = sdkInfo.getVmId();
            } else if (this.vmName == null) {
                sdkInfo = this.getConnectionInfoById(this.httpClient, this.vmId);
                this.vmName = sdkInfo.getVmName();
            }
            this.checkForOpenedSSHTunnels();
            this.setVirtualMachineName(sdkInfo);
            ConnectionInfo info = this.convertSDKConnectionInfoToConnectionInfo(sdkInfo);
            int tunnelPort = this.openTunnel(landscapeHost, info);
            System.out.println("SSH tunnel ready on port: " + tunnelPort);
            System.out.println(String.format("This tunnel will close automatically in 24 hours on %s.", this.getNextDate()));
        }
        catch (PortUnavailableException e) {
            throw new CommandException("The requested port is already in use. Try a different one.");
        }
        catch (CommandException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CommandException(e.getMessage(), (Throwable)e, 215);
        }
    }

    private String getNextDate() {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 1);
        date = calendar.getTime();
        return date.toString();
    }

    protected ConnectionInfo convertSDKConnectionInfoToConnectionInfo(SDKConnectionInfo sdkInfo) {
        ConnectionInfo info = new ConnectionInfo(sdkInfo.getCertificate(), sdkInfo.getRoutingInfo(), sdkInfo.getTunnelId(), sdkInfo.getVirtualHosts());
        return info;
    }

    protected void checkForOpenedSSHTunnels() {
        List<Integer> opennedTunnels;
        Map<String, List<Integer>> openedSSHTunnels = this.getOpenedSSHTunnels();
        if (!openedSSHTunnels.isEmpty() && openedSSHTunnels.containsKey(this.vmId) && (opennedTunnels = openedSSHTunnels.get(this.vmId)) != null && !openedSSHTunnels.isEmpty()) {
            StringBuilder warning = new StringBuilder(String.format(Constants.OPEN_SSH_TUNNEL_WARNING_MESSAGE, this.vmId));
            for (Integer port : opennedTunnels) {
                warning.append("         ").append(this.vmId).append(":").append(port).append(Constants.LINE_SEPARATOR);
            }
            System.out.println(warning.toString());
        }
    }

    protected Map<String, List<Integer>> getOpenedSSHTunnels() {
        try {
            return this.getTunnelClient().listTunnels();
        }
        catch (Exception e) {
            throw new CommandException(e.getMessage(), (Throwable)e);
        }
    }

    protected String getLandscapeHost() throws MalformedURLException {
        URL hostURL = new URL(this.host);
        String landscapeHost = hostURL.getHost();
        return landscapeHost;
    }

    protected int openTunnel(String landscapeHost, ConnectionInfo info) throws IOException, ConnectionFailedException, PortUnavailableException {
        int tunnelPort = this.getTunnelClient().openTunnel(this.vmId, this.port, landscapeHost, this.proxySettings, info);
        return tunnelPort;
    }

    protected TunnelProcessClient getTunnelClient() {
        return this.tunnelClient;
    }

    protected void setVirtualMachineName(SDKConnectionInfo info) throws IOException {
        String vmName = info.getVmName();
        if (vmName != null && !vmName.isEmpty()) {
            this.getTunnelClient().setServerName(this.vmId, vmName);
        }
    }
}

