/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.js.logging;

import com.sap.core.js.logging.LoggingLifecycleHandler;
import com.sap.core.js.logging.command.LoggingCommandProvider;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final String LOGGING_MBEAN_NAME = "com.sap.js:name=Logging,type=Logging";
    private static final Logger logger = LoggerFactory.getLogger(Activator.class);
    private CommandProvider loggingCommand;
    private ServiceRegistration commandReg;
    private LoggingLifecycleHandler loggingLifecycleHandler;

    public void start(BundleContext context) {
        if (logger.isDebugEnabled()) {
            logger.debug("Starting logging with the logging bundle's activator.");
        }
        this.loggingCommand = new LoggingCommandProvider();
        this.commandReg = context.registerService(CommandProvider.class.getName(), (Object)this.loggingCommand, null);
        this.loggingLifecycleHandler = new LoggingLifecycleHandler();
        this.loggingLifecycleHandler.initialize();
    }

    public void stop(BundleContext context) {
        if (logger.isDebugEnabled()) {
            logger.debug("Stopping logging with the logging bundle's activator.");
        }
        this.commandReg.unregister();
        this.commandReg = null;
        this.loggingCommand = null;
        if (this.loggingLifecycleHandler != null) {
            this.loggingLifecycleHandler.destroy();
        } else {
            logger.error("Internal loggingLifecycleHandler object is not available. It must have been initialized on the start of the logging bundle.");
        }
    }
}

