/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.js.logging;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.pattern.PatternLayoutEncoderBase;
import java.util.ArrayList;

public class LJSPatternLayoutEncoder
extends PatternLayoutEncoderBase<ILoggingEvent> {
    private static final String EOL = System.getProperty("line.separator");
    private static final String HEADER_STR = "FILE_TYPE:DAAA96DE-B0FB-4c6e-AF7B-A445F5BF9BE2" + EOL;
    private static final String FILE_ID_STR = "FILE_ID:";
    private static final String ENCODING_STR = "ENCODING:[UTF8|NWCJS:ASCII]" + EOL;
    private static final String RECORD_STR = "RECORD_SEPARATOR:124" + EOL;
    private static final String COLUMN_SEP_STR = "COLUMN_SEPARATOR:35" + EOL;
    private static final String ESC_CHAR_STR = "ESC_CHARACTER:92" + EOL;
    private static final String SEVERITY_MAP_STR = "SEVERITY_MAP:FINEST|Information|FINER|Information|FINE|Information|CONFIG|Information|DEBUG|Information|PATH|Information|INFO|Information|WARNING|Warning|ERROR|Error|SEVERE|Error|FATAL|Error" + EOL;
    private static final String HEADER_END_STR = "HEADER_END" + EOL + EOL;
    private String colums;
    private static final char ESCAPE_CHAR = '%';
    private static final int LITERAL_STATE = 0;
    private static final int CONVERTER_STATE = 1;
    private static final int DOT_STATE = 3;
    private static final int MIN_STATE = 4;
    private static final int MAX_STATE = 5;
    private int state;

    public void start() {
        PatternLayout patternLayout = new PatternLayout();
        patternLayout.setContext(this.context);
        patternLayout.setPattern(this.getPattern());
        patternLayout.setFileHeader(this.getHeader());
        patternLayout.start();
        this.layout = patternLayout;
        super.start();
    }

    public String getHeader() {
        String[] columsArr = this.parsePattern(this.getPattern());
        this.colums = this.getColumns(columsArr);
        StringBuffer buf = new StringBuffer();
        buf.append(HEADER_STR);
        buf.append(FILE_ID_STR + System.currentTimeMillis() + EOL);
        buf.append(ENCODING_STR);
        buf.append(RECORD_STR);
        buf.append(COLUMN_SEP_STR);
        buf.append(ESC_CHAR_STR);
        buf.append(this.colums);
        buf.append(SEVERITY_MAP_STR);
        buf.append(HEADER_END_STR);
        return new String(buf);
    }

    private String getColumns(String[] pattern) {
        this.colums = "COLUMNS:";
        int i = 0;
        while (i < pattern.length) {
            this.colums = String.valueOf(this.colums) + this.getColumnName(pattern[i]);
            ++i;
        }
        return String.valueOf(this.colums) + EOL;
    }

    private String getColumnName(String conversionStr) {
        if (conversionStr.equals("d")) {
            return "Time|";
        }
        if (conversionStr.equals("o")) {
            return "TZone|";
        }
        if (conversionStr.equals("p")) {
            return "Severity|";
        }
        if (conversionStr.equals("c")) {
            return "Logger|";
        }
        if (conversionStr.equals("a")) {
            return "ACH|";
        }
        if (conversionStr.equals("u")) {
            return "User|";
        }
        if (conversionStr.equals("t")) {
            return "Thread|";
        }
        if (conversionStr.equals("b")) {
            return "Bundle name|";
        }
        if (conversionStr.equals("m")) {
            return "Text|";
        }
        if (conversionStr.equals("z")) {
            return "JPSpace|JPAppliance|JPComponent|";
        }
        if (conversionStr.equals("s")) {
            return "DSR Root Context ID|DSR Transaction|DSR Connection|DSR Counter|";
        }
        if (conversionStr.equals("X{tenant_alias}")) {
            return "Tenant Alias|";
        }
        if (conversionStr.equals("X{tenant_id}")) {
            return "Tenant ID|";
        }
        if (conversionStr.equals("Q")) {
            return "Correlation ID|";
        }
        return "";
    }

    private String[] parsePattern(String pattern) {
        ArrayList<String> patternArr = new ArrayList<String>();
        int i = 0;
        int patternLength = pattern.length();
        block15: while (i < patternLength) {
            char c = pattern.charAt(i++);
            block0 : switch (this.state) {
                case 0: {
                    if (i == patternLength || c != '%') continue block15;
                    switch (pattern.charAt(i)) {
                        case '%': {
                            ++i;
                            break block0;
                        }
                        case 'n': {
                            ++i;
                            break block0;
                        }
                    }
                    this.state = 1;
                    break;
                }
                case 1: {
                    switch (c) {
                        case '-': {
                            break block0;
                        }
                        case '.': {
                            this.state = 3;
                            break block0;
                        }
                    }
                    if (c >= '0' && c <= '9') {
                        this.state = 4;
                        break;
                    }
                    if (c == 'X' && pattern.charAt(i) == '{') {
                        String mdcStr = this.getMdcConversionString(pattern, i - 1);
                        patternArr.add(mdcStr);
                    } else {
                        patternArr.add(String.valueOf(c));
                    }
                    this.state = 0;
                    break;
                }
                case 4: {
                    if (c >= '0' && c <= '9') continue block15;
                    if (c == '.') {
                        this.state = 3;
                        break;
                    }
                    patternArr.add(String.valueOf(c));
                    this.state = 0;
                    break;
                }
                case 3: {
                    if (c >= '0' && c <= '9') {
                        this.state = 5;
                        break;
                    }
                    this.state = 0;
                    break;
                }
                case 5: {
                    if (c >= '0' && c <= '9') continue block15;
                    patternArr.add(String.valueOf(c));
                    this.state = 0;
                }
            }
        }
        return patternArr.toArray(new String[patternArr.size()]);
    }

    private String getMdcConversionString(String pattern, int indexOfX) {
        int indexOfClosingBracket = pattern.indexOf(125, indexOfX);
        this.validateMdcParameter(pattern, indexOfX);
        return pattern.substring(indexOfX, indexOfClosingBracket + 1);
    }

    private void validateMdcParameter(String pattern, int indexOfX) {
        int indexOfClosingBracket = pattern.indexOf(125, indexOfX);
        if (indexOfClosingBracket < 1 | pattern.charAt(indexOfX) != 'X') {
            throw new IllegalArgumentException("Illegal index of 'X' provided!");
        }
        int relativeIndexOfClosingBracket = indexOfClosingBracket - indexOfX;
        if (relativeIndexOfClosingBracket < 3) {
            throw new IllegalArgumentException("Illegal pattern provided!");
        }
        if (pattern.substring(indexOfX, indexOfClosingBracket + 1).contains(" ")) {
            throw new IllegalArgumentException("Illegal MDC key! It should not contain empty spaces!");
        }
    }
}

