/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.js.logging;

import ch.qos.logback.classic.LoggerContext;
import com.sap.core.js.logging.mbeans.Logging;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingLifecycleHandler {
    private static final String LOGGING_MBEAN_NAME = "com.sap.js:name=Logging,type=Logging";
    private static final Logger logger = LoggerFactory.getLogger(LoggingLifecycleHandler.class);
    private String registeredMbean;
    private MBeanServer mbeanServer;

    public LoggingLifecycleHandler() {
        this(ManagementFactory.getPlatformMBeanServer());
    }

    public LoggingLifecycleHandler(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
        this.registeredMbean = "";
    }

    public void initialize() {
        this.registerLoggingMBeans();
        this.setPackagingDataEnabled(false);
    }

    public void destroy() {
        this.unregisterLoggingMBeans();
    }

    public void registerLoggingMBeans() {
        if (logger.isDebugEnabled()) {
            logger.debug("Start registerring logging mBean with object namecom.sap.js:name=Logging,type=Logging");
        }
        try {
            this.mbeanServer.registerMBean(new Logging(), new ObjectName(LOGGING_MBEAN_NAME));
            this.registeredMbean = LOGGING_MBEAN_NAME;
        }
        catch (InstanceAlreadyExistsException e) {
            logger.error("MBean with name [com.sap.js:name=Logging,type=Logging] is already registered:", (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            logger.error("MBean with name [com.sap.js:name=Logging,type=Logging] cannot be registered:", (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            logger.error("MBean with name [com.sap.js:name=Logging,type=Logging] cannot be registered:", (Throwable)e);
        }
        catch (MalformedObjectNameException e) {
            logger.error("MBean name [com.sap.js:name=Logging,type=Logging] is not correct and cannot be registered:", (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Currently registered logging mbean [" + this.registeredMbean + "].");
        }
    }

    public void unregisterLoggingMBeans() {
        if (logger.isDebugEnabled()) {
            logger.debug("Start unregisterring logging mBean with object namecom.sap.js:name=Logging,type=Logging");
        }
        try {
            this.mbeanServer.unregisterMBean(new ObjectName(LOGGING_MBEAN_NAME));
            this.registeredMbean = "";
        }
        catch (MBeanRegistrationException e) {
            logger.error("MBean with name [com.sap.js:name=Logging,type=Logging] cannot be unregistered", (Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            logger.error("MBean with name [com.sap.js:name=Logging,type=Logging] does not exist", (Throwable)e);
        }
        catch (MalformedObjectNameException e) {
            logger.error("MBean name [com.sap.js:name=Logging,type=Logging] is not correct and cannot be registered:", (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Currently registered logging mbean [" + this.registeredMbean + "].");
        }
    }

    public void setPackagingDataEnabled(boolean flag) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Configuring default packiging data calculation feature to [" + flag + "].");
            }
            LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
            lc.setPackagingDataEnabled(flag);
        }
        catch (Exception e) {
            logger.error("Cannot configure package data calculation of the default logger context. Exception occurred!", (Throwable)e);
        }
    }

    protected String getRegisteredMbean() {
        return this.registeredMbean;
    }
}

