/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.js.logging.command;

import com.sap.core.js.logging.mbeans.LogbackMBeanDelegator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;

public class LoggingCommandProvider
implements CommandProvider {
    private static final String EOL = System.getProperty("line.separator");
    private final LogbackMBeanDelegator mbeanDelegator = new LogbackMBeanDelegator();

    public Object _list_loggers(CommandInterpreter intp) {
        intp.println((Object)("Root severity is: " + this.mbeanDelegator.getLoggerLevel("ROOT")));
        intp.println((Object)"Loggers:");
        TreeMap<String, String> map = new TreeMap<String, String>(this.mbeanDelegator.listLoggerNamesAndLevels());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            intp.println((Object)("\t" + entry.getKey() + " : " + entry.getValue()));
        }
        return null;
    }

    public Object _change_log_level(CommandInterpreter intp) {
        String logger = intp.nextArgument();
        String level = intp.nextArgument();
        try {
            this.mbeanDelegator.setLoggerLevel(logger, level);
        }
        catch (Exception ex) {
            Throwable t = ex.getCause();
            String message = t != null ? t.getMessage() : ex.getMessage();
            intp.println((Object)message);
        }
        return null;
    }

    public String getHelp() {
        StringBuilder sb = new StringBuilder();
        sb.append("---Logging commands---");
        sb.append(String.valueOf(EOL) + "\tlist_loggers - view all loggers with their effective severity");
        sb.append(String.valueOf(EOL) + "\tchange_log_level <logger name> <level> - change logger level");
        sb.append(String.valueOf(EOL) + "\t\t available log levels: OFF, FATAL, ERROR, WARN, INFO, DEBUG, ALL, TRACE");
        sb.append(String.valueOf(EOL) + "\t\t example:  change_log_level com.sap.core.js.logging.mbeans.MBeanManager ERROR" + EOL);
        return sb.toString();
    }
}

