/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.js.logging.config;

import com.sap.core.js.logging.mbeans.LogbackMBeanDelegator;
import com.sap.core.js.logging.mbeans.LoggingCfgHelper;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingConfigurator {
    private static final String SYSTEM_OUT = "System.out";
    private static final String SYSTEM_ERR = "System.err";
    private LogbackMBeanDelegator mbeanDelegator = new LogbackMBeanDelegator();
    private Logger logger = LoggerFactory.getLogger(LoggingConfigurator.class);
    public static final String DECORATED_KEY_PREFIX = "JS";
    public static final String DECORATED_KEY_DELIMITER = "@";

    public void updateProperties(Dictionary<String, String> properties) {
        if (properties != null) {
            Properties loggerNamesLevels = new Properties();
            Enumeration<String> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                loggerNamesLevels.put(key, properties.get(key));
            }
            this.updateProperties(loggerNamesLevels);
        }
    }

    public void updateProperties(Properties properties) {
        if (properties != null) {
            LoggingCfgHelper loggingCfgHelper = LoggingCfgHelper.getInstance();
            this.processSystemLoggers(properties);
            Set<Object> keys = properties.keySet();
            for (Object decoratedKey : keys) {
                String loggerLevelValue = (String)properties.get(decoratedKey);
                String undecoratedKey = LoggingConfigurator.decodeDecoratedKey((String)decoratedKey);
                String actualLoggerName = loggingCfgHelper.findLoggerNames(undecoratedKey);
                if (actualLoggerName == null) continue;
                try {
                    this.mbeanDelegator.setLoggerLevel(actualLoggerName, loggerLevelValue);
                }
                catch (IllegalArgumentException iae) {
                    this.logger.error("Failed to apply logger configuration [{}]=[{}] (decorated_key=[{}]; undecorated_key=[{}]): ", new Object[]{actualLoggerName, loggerLevelValue, decoratedKey, undecoratedKey, iae});
                }
            }
            loggingCfgHelper.setProperties(properties);
        }
    }

    public static String decodeDecoratedKey(String decoratedKey) {
        int delimiterIndex = decoratedKey.indexOf(DECORATED_KEY_DELIMITER);
        if (decoratedKey.startsWith(DECORATED_KEY_PREFIX) && delimiterIndex != -1) {
            String number = decoratedKey.substring(DECORATED_KEY_PREFIX.length(), delimiterIndex);
            try {
                Integer.parseInt(number);
                return decoratedKey.substring(delimiterIndex + DECORATED_KEY_DELIMITER.length());
            }
            catch (NumberFormatException numberFormatException) {
                return decoratedKey;
            }
        }
        return decoratedKey;
    }

    private void processSystemLoggers(Properties properties) {
        if (properties.get(SYSTEM_ERR) != null) {
            properties.remove("system.logger.System.err");
        }
        if (properties.get(SYSTEM_OUT) != null) {
            properties.remove("system.logger.System.out");
        }
    }
}

