/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.js.logging.filter;

import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import java.util.HashSet;
import java.util.Set;

public class LoggerMatchFilter
extends Filter<LoggingEvent> {
    private boolean acceptOnMatch = true;
    private Set<String> loggersToMatch = new HashSet<String>();

    public void setLoggerToMatch(String logger) {
        if (logger == null) {
            this.loggersToMatch.add("root");
        } else {
            this.loggersToMatch.add(logger);
        }
    }

    public String getLoggerToMatch() {
        return "root";
    }

    public void setAcceptOnMatch(boolean acceptOnMatch) {
        this.acceptOnMatch = acceptOnMatch;
    }

    public boolean getAcceptOnMatch() {
        return this.acceptOnMatch;
    }

    public FilterReply decide(LoggingEvent event) {
        if (this.loggersToMatch.contains(event.getLoggerName())) {
            if (this.acceptOnMatch) {
                return FilterReply.ACCEPT;
            }
            return FilterReply.DENY;
        }
        return FilterReply.NEUTRAL;
    }
}

