/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.js.logging.mbeans;

import com.sap.core.js.logging.mbeans.Logging;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogbackMBeanDelegator {
    private static final String LOGBACK_MBEAN_NAME = "ch.qos.logback.classic:Name=default,Type=ch.qos.logback.classic.jmx.JMXConfigurator";
    private static final String JAVA_UTIL_MBEAN_NAME = "java.util.logging:type=Logging";
    private static final String GET_EFFECTIVE_LOGGER_LEVEL = "getLoggerEffectiveLevel";
    private static final String SET_LOGGER_LEVEL = "setLoggerLevel";
    private static final String GET_LOGGER_LEVEL = "getLoggerLevel";
    private static final String EMPTY_STRING = "";
    private Logger logger = LoggerFactory.getLogger(Logging.class);

    public String getLoggerLevel(String loggerName) {
        this.checkLoggerArgument(loggerName);
        String level = this.getLoggerLevelFromMBean(loggerName);
        if (level != null && !level.equals(EMPTY_STRING)) {
            return level;
        }
        level = this.getLoggerLevelFromJavaUtilMBean(loggerName);
        if (level != null && !level.equals(EMPTY_STRING)) {
            return level;
        }
        return this.getLoggerLevelFromMBean("ROOT");
    }

    public void setLoggerLevel(String loggerName, String level) {
        this.checkLoggerArgument(loggerName);
        this.checkLevelArgumentCorrect(level);
        String slf4jLevel = this.translateToLevelSupportedBySlf4j(loggerName, level);
        try {
            ObjectName mbean = new ObjectName(LOGBACK_MBEAN_NAME);
            ManagementFactory.getPlatformMBeanServer().invoke(mbean, SET_LOGGER_LEVEL, new Object[]{loggerName, slf4jLevel}, new String[]{String.class.getName(), String.class.getName()});
        }
        catch (Exception e) {
            this.logger.error("Cannot invoke operation setLoggerLevel of MBean [ch.qos.logback.classic:Name=default,Type=ch.qos.logback.classic.jmx.JMXConfigurator]", (Throwable)e);
        }
    }

    public List<String> listLoggerNames() {
        ObjectName mbean;
        List logbackList = null;
        try {
            mbean = new ObjectName(LOGBACK_MBEAN_NAME);
            logbackList = (List)ManagementFactory.getPlatformMBeanServer().getAttribute(mbean, "LoggerList");
        }
        catch (Exception e) {
            this.logger.error("Cannot get LoggerList from MBean [ch.qos.logback.classic:Name=default,Type=ch.qos.logback.classic.jmx.JMXConfigurator]", (Throwable)e);
            return null;
        }
        try {
            String[] javaUtilList;
            mbean = new ObjectName(JAVA_UTIL_MBEAN_NAME);
            String[] stringArray = javaUtilList = (String[])ManagementFactory.getPlatformMBeanServer().getAttribute(mbean, "LoggerNames");
            int n = javaUtilList.length;
            int n2 = 0;
            while (n2 < n) {
                String loggerName = stringArray[n2];
                if (loggerName != null && !loggerName.equals(EMPTY_STRING) && !logbackList.contains(loggerName)) {
                    logbackList.add(loggerName);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            this.logger.error("Cannot get LoggerNames from MBean [java.util.logging:type=Logging]. Only loggers from [ch.qos.logback.classic:Name=default,Type=ch.qos.logback.classic.jmx.JMXConfigurator] will be listed", (Throwable)e);
        }
        return logbackList;
    }

    public Map<String, String> listLoggerNamesAndLevels() {
        List<String> loggers = this.listLoggerNames();
        HashMap<String, String> loggerNamesLevels = new HashMap<String, String>();
        for (String logger : loggers) {
            String level = this.getLoggerLevel(logger);
            loggerNamesLevels.put(logger, level);
        }
        return loggerNamesLevels;
    }

    private String getLoggerLevelFromMBean(String loggerName) {
        try {
            ObjectName logbackMbean = new ObjectName(LOGBACK_MBEAN_NAME);
            return (String)ManagementFactory.getPlatformMBeanServer().invoke(logbackMbean, GET_EFFECTIVE_LOGGER_LEVEL, new Object[]{loggerName}, new String[]{String.class.getName()});
        }
        catch (Exception e) {
            this.logger.error("Cannot invoke operation getLoggerEffectiveLevel of MBean [ch.qos.logback.classic:Name=default,Type=ch.qos.logback.classic.jmx.JMXConfigurator]", (Throwable)e);
            return null;
        }
    }

    private String getLoggerLevelFromJavaUtilMBean(String loggerName) {
        try {
            ObjectName javaUtilMbean = new ObjectName(JAVA_UTIL_MBEAN_NAME);
            return (String)ManagementFactory.getPlatformMBeanServer().invoke(javaUtilMbean, GET_LOGGER_LEVEL, new Object[]{loggerName}, new String[]{String.class.getName()});
        }
        catch (Exception e) {
            this.logger.error("Cannot invoke operation getLoggerLevel of MBean [java.util.logging:type=Logging]", (Throwable)e);
            return null;
        }
    }

    private void checkLoggerArgument(String loggerName) {
        if (loggerName == null || loggerName.equals(EMPTY_STRING)) {
            throw new IllegalArgumentException("Parameter is not correct, logger name cannon be [" + loggerName + "]");
        }
    }

    protected void checkLevelArgumentCorrect(String level) {
        if (level == null || level.equals(EMPTY_STRING)) {
            throw new IllegalArgumentException("Parameter level must be one of the following values " + Arrays.toString((Object[])Levels.values()));
        }
        level = level.toUpperCase();
        Levels[] levelsArray = Levels.values();
        int n = levelsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Levels tmpLevel = levelsArray[n2];
            if (tmpLevel.toString().equals(level)) {
                return;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Parameter level must be one of the following values " + Arrays.toString((Object[])Levels.values()));
    }

    protected String translateToLevelSupportedBySlf4j(String loggerName, String level) {
        if (level.toUpperCase().equals(Levels.FATAL.toString())) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Logger " + loggerName + " is requested to be set to " + (Object)((Object)Levels.FATAL) + " but will be set to " + (Object)((Object)Levels.ERROR) + " since " + (Object)((Object)Levels.FATAL) + " is not supported by slf4j");
            }
            return Levels.ERROR.toString();
        }
        return level;
    }

    protected static enum Levels {
        OFF,
        ERROR,
        FATAL,
        WARN,
        INFO,
        DEBUG,
        TRACE,
        ALL;

    }
}

