/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.js.logging.mbeans;

import com.sap.core.js.logging.mbeans.LogbackMBeanDelegator;
import com.sap.core.js.logging.mbeans.LoggingCfgHelper;
import com.sap.core.js.logging.mbeans.LoggingMBean;
import java.util.List;
import java.util.Map;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.StandardMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Logging
extends StandardMBean
implements LoggingMBean {
    private static final String SET_LOGGER_LEVEL = "setLoggerLevel";
    private static final String GET_LOGGER_LEVEL = "getLoggerLevel";
    private static final String SET_LOGGER_LEVEL_DESCR = "Sets the provided level to the specified logger. Accepted level values are: OFF, FATAL, ERROR, WARN, INFO, DEBUG, TRACE, ALL.";
    private static final String GET_LOGGER_LEVEL_DESCR = "Returns the current level for the specified logger.";
    private static final String LOGGER_NAME_DESCR = "The Logger name.";
    private static final String LEVEL_DESCR = "The level that will be set. It must be one of the following values [OFF, FATAL, ERROR, WARN, INFO, DEBUG, TRACE, ALL].";
    private LogbackMBeanDelegator mbeanDelegator;
    private static final Logger logger = LoggerFactory.getLogger(Logging.class);

    public Logging() {
        super(LoggingMBean.class, false);
        this.mbeanDelegator = new LogbackMBeanDelegator();
    }

    public Logging(LogbackMBeanDelegator mbeanDelegator) {
        super(LoggingMBean.class, false);
        this.mbeanDelegator = mbeanDelegator;
    }

    @Override
    public String getLoggerLevel(String loggerName) {
        if (logger.isDebugEnabled()) {
            logger.debug("Logging mBean is invoked. Operation is [getLoggerLevel]; loggerName is [" + loggerName + "].");
        }
        return this.mbeanDelegator.getLoggerLevel(loggerName);
    }

    @Override
    public void setLoggerLevel(String loggerName, String level) {
        if (logger.isDebugEnabled()) {
            logger.debug("Logging mBean is invoked. Operation is [setLoggerLevel]; loggerName is [" + loggerName + "]. New logger level is [" + level + "]");
        }
        this.mbeanDelegator.setLoggerLevel(loggerName, level);
    }

    @Override
    public void setLoggerLevel(String loggerName, String level, boolean persist) {
        if (logger.isDebugEnabled()) {
            logger.debug("Logging mBean is invoked. Operation is [setLoggerLevel]; loggerName is [" + loggerName + "], new logger level is [" + level + "], persist flag value is [" + persist + "].");
        }
        this.mbeanDelegator.setLoggerLevel(loggerName, level);
        if (persist) {
            LoggingCfgHelper.getInstance().persistInLoggingCfg(loggerName, level);
        }
    }

    @Override
    public List<String> listLoggerNames() {
        if (logger.isDebugEnabled()) {
            logger.debug("Logging mBean is invoked. Operation is [listLoggerNames].");
        }
        return this.mbeanDelegator.listLoggerNames();
    }

    @Override
    public Map<String, String> listLoggerNamesAndLevels() {
        if (logger.isDebugEnabled()) {
            logger.debug("Logging mBean is invoked. Operation is [listLoggerNamesAndLevels].");
        }
        return this.mbeanDelegator.listLoggerNamesAndLevels();
    }

    @Override
    protected final String getDescription(MBeanOperationInfo info) {
        String name = info.getName();
        if (SET_LOGGER_LEVEL.equals(name)) {
            return SET_LOGGER_LEVEL_DESCR;
        }
        if (GET_LOGGER_LEVEL.equals(name)) {
            return GET_LOGGER_LEVEL_DESCR;
        }
        return super.getDescription(info);
    }

    @Override
    protected final String getDescription(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        String opName = op.getName();
        if ((SET_LOGGER_LEVEL.equals(opName) || GET_LOGGER_LEVEL.equals(opName)) && sequence == 0) {
            return LOGGER_NAME_DESCR;
        }
        if (SET_LOGGER_LEVEL.equals(opName) && sequence == 1) {
            return LEVEL_DESCR;
        }
        return super.getDescription(op, param, sequence);
    }
}

