/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.js.logging.mbeans;

import com.sap.core.js.logging.mbeans.Logging;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingCfgHelper {
    private static final LoggingCfgHelper INSTANCE = new LoggingCfgHelper();
    private static final String LOGGING_CFG_FILE = String.valueOf(System.getProperty("server.config.home")) + File.separator + "config_master" + File.separator + "com.sap.js.logging" + File.separator + "logging.cfg";
    protected static final String EOL = System.getProperty("line.separator");
    private static final String COMMENTS_BORDER_LINE = "##############################################################";
    private static final String CONFIG_PREFIX_LOG4J_LOGGER = "log4j.logger.";
    private static final String CONFIG_PREFIX_JAVAUTIL_LOGGER = "java.logger.";
    public static final String CONFIG_PREFIX_SYSTEM_LOGGER = "system.logger.";
    private static final String JAVAUTIL_ROOT_LEVEL = "java.root.level";
    private Logger logger = LoggerFactory.getLogger(Logging.class);
    private Properties loggers = new Properties();
    private String logging_cfg_header = "";

    private LoggingCfgHelper() {
    }

    public static LoggingCfgHelper getInstance() {
        return INSTANCE;
    }

    private String readFileConfigurationHeader(File f) throws IOException {
        String string;
        block8: {
            BufferedReader br = null;
            try {
                String line;
                br = new BufferedReader(new FileReader(f));
                String fileToString = "";
                while ((line = br.readLine()) != null) {
                    fileToString = String.valueOf(fileToString) + line + EOL;
                }
                String[] splits = fileToString.split(COMMENTS_BORDER_LINE);
                string = COMMENTS_BORDER_LINE + splits[1] + COMMENTS_BORDER_LINE;
                if (br == null) break block8;
            }
            catch (Throwable throwable) {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                br.close();
            }
            catch (IOException iOException) {}
        }
        return string;
    }

    public void persistInLoggingCfg(String loggerName, String level) {
        block15: {
            Object oldLevel = this.loggers.get(loggerName);
            if (oldLevel != null && level.equals(oldLevel.toString())) {
                return;
            }
            this.loggers.put(loggerName, level);
            OutputStreamWriter fw = null;
            try {
                try {
                    File config_file;
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Will try to persist logger " + loggerName + " with level " + level + " in " + LOGGING_CFG_FILE);
                    }
                    if ((config_file = new File(LOGGING_CFG_FILE).getCanonicalFile()).exists() && this.logging_cfg_header.isEmpty()) {
                        this.logging_cfg_header = this.readFileConfigurationHeader(config_file);
                    }
                    fw = new FileWriter(config_file);
                    String header = this.logging_cfg_header.replaceFirst("#", "");
                    this.loggers.store(fw, header);
                }
                catch (IOException e) {
                    this.logger.error("Error while persisting the logging configuration", (Throwable)e);
                    if (fw == null) break block15;
                    try {
                        fw.close();
                    }
                    catch (IOException e2) {
                        this.logger.error("Error while closing file writer", (Throwable)e2);
                    }
                }
            }
            finally {
                if (fw != null) {
                    try {
                        fw.close();
                    }
                    catch (IOException e) {
                        this.logger.error("Error while closing file writer", (Throwable)e);
                    }
                }
            }
        }
    }

    public String findLoggerNames(String key) {
        if (key.startsWith(CONFIG_PREFIX_LOG4J_LOGGER)) {
            return key.substring(CONFIG_PREFIX_LOG4J_LOGGER.length());
        }
        if (key.startsWith(CONFIG_PREFIX_JAVAUTIL_LOGGER)) {
            return key.substring(CONFIG_PREFIX_JAVAUTIL_LOGGER.length());
        }
        if (key.startsWith(CONFIG_PREFIX_SYSTEM_LOGGER)) {
            return key.substring(CONFIG_PREFIX_SYSTEM_LOGGER.length());
        }
        if (key.equals(JAVAUTIL_ROOT_LEVEL)) {
            return key;
        }
        if (!key.equals("service.pid") && !key.equals("enable.archiving")) {
            return key;
        }
        return null;
    }

    public void setProperties(Properties p) {
        this.loggers = p;
    }
}

