/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.js.logging.trace;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.FileAppender;
import com.sap.core.js.logging.trace.LoggingTraceFilter;
import java.io.IOException;
import java.util.Map;

public class LogBackTraceAppender
extends FileAppender<ILoggingEvent> {
    private LoggingTraceFilter filter;
    private Map<String, Level> loggers;

    public LogBackTraceAppender(Map<String, Level> loggers, LoggingTraceFilter filter) throws IOException {
        this.filter = filter;
        this.loggers = loggers;
    }

    public void doAppend(ILoggingEvent event) {
        String loggerName = event.getLoggerName();
        if (this.loggers.containsKey(loggerName)) {
            Level oldLevel;
            if (!this.filter.isRequestTraced() && (oldLevel = this.loggers.get(loggerName)).toInteger() < event.getLevel().toInteger()) {
                return;
            }
            super.append((Object)event);
        }
    }
}

