/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.js.logging.trace;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import com.sap.core.js.logging.LJSPatternLayoutEncoder;
import com.sap.core.js.logging.trace.LogBackTraceAppender;
import com.sap.core.js.logging.trace.LoggingTraceFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class LoggingTraceService {
    LogBackTraceAppender appender;
    private String[] loggers;
    Map<String, Level> cache = new HashMap<String, Level>();
    Logger logger;
    boolean started;

    public void startSessionTrace(String[] loggers, String[] levels, LoggingTraceFilter filter) {
        this.logger = (Logger)LoggerFactory.getLogger(LoggingTraceService.class);
        this.logger.debug("startSessionTrace method called");
        this.loggers = loggers;
        if (filter == null) {
            throw new IllegalArgumentException("Filter interface is not provided");
        }
        if (loggers == null) {
            throw new IllegalArgumentException("Logger names are not provided");
        }
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        int i = 0;
        while (i < loggers.length) {
            Logger tmp = (Logger)LoggerFactory.getLogger((String)loggers[i]);
            if (tmp.getEffectiveLevel() == null) {
                this.cache.put(loggers[i], root.getEffectiveLevel());
            } else {
                this.cache.put(loggers[i], tmp.getEffectiveLevel());
            }
            tmp.setLevel(Level.ALL);
            ++i;
        }
        LoggerContext context = root.getLoggerContext();
        LJSPatternLayoutEncoder patternLayoutEncoder = new LJSPatternLayoutEncoder();
        patternLayoutEncoder.setContext((Context)context);
        patternLayoutEncoder.setPattern("%1d{yyyy-MM-dd HH:mm:ss}#%o#%c#%p#%m#%t#%s#%a%n");
        patternLayoutEncoder.start();
        try {
            this.appender = new LogBackTraceAppender(this.cache, filter);
            this.appender.setEncoder((Encoder)patternLayoutEncoder);
            this.appender.setFile("trace.log");
            this.appender.setContext((Context)context);
            this.appender.start();
            root.addAppender((Appender)this.appender);
            this.started = true;
        }
        catch (IOException ioe) {
            this.logger.error("Error creating appender ", (Throwable)ioe);
        }
    }

    public void stopSessionTrace() {
        if (this.started) {
            this.logger.debug("stopSessionTrace method called");
            Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
            if (this.appender != null) {
                root.detachAppender((Appender)this.appender);
            }
            if (this.cache != null) {
                int i = 0;
                while (i < this.loggers.length) {
                    Logger tmp = (Logger)LoggerFactory.getLogger((String)this.loggers[i]);
                    tmp.setLevel(this.cache.get(this.loggers[i]));
                    ++i;
                }
            }
        }
    }
}

