/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb.json.schema.model;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.eclipse.persistence.internal.jaxb.json.schema.model.JsonType;
import org.eclipse.persistence.internal.jaxb.json.schema.model.Property;
import org.eclipse.persistence.oxm.annotations.XmlVariableNode;

public class JsonSchema {
    @XmlElement(name="$schema")
    private String schemaVersion = "http://json-schema.org/draft-04/schema#";
    @XmlElement(name="title")
    private String title;
    @XmlElement(name="type")
    private JsonType type;
    @XmlVariableNode(value="name")
    @XmlElementWrapper(name="properties")
    private Map<String, Property> properties;
    @XmlElement(name="items")
    private Property items;
    @XmlVariableNode(value="name")
    @XmlElementWrapper(name="definitions")
    private Map<String, Property> definitions;
    private List<String> required;

    public void setTitle(String title) {
        this.title = title;
    }

    public void setType(JsonType type) {
        this.type = type;
    }

    public void addProperty(Property property) {
        this.getProperties().put(property.getName(), property);
    }

    public Map<String, Property> getProperties() {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, Property>();
        }
        return this.properties;
    }

    public Map<String, Property> getDefinitions() {
        if (this.definitions == null) {
            this.definitions = new LinkedHashMap<String, Property>();
        }
        return this.definitions;
    }

    public Property getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    public Property getItems() {
        return this.items;
    }

    public void setItems(Property items) {
        this.items = items;
    }
}

