/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.impl;

import com.sap.cloud.security.oauth2.commons.exception.OAuthInvalidAuthzHeaderException;
import javax.servlet.http.HttpServletRequest;

public class AccessTokenParser {
    private static final String BEARER_TOKEN_PREFIX = "Bearer";

    public static String parse(HttpServletRequest request) throws OAuthInvalidAuthzHeaderException {
        String authzHeader = request.getHeader("Authorization");
        if (authzHeader == null) {
            throw new OAuthInvalidAuthzHeaderException("Missing Authorization header");
        }
        String[] chunks = authzHeader.split(" ", 2);
        if (chunks.length < 2) {
            throw new OAuthInvalidAuthzHeaderException("Invalid Authorization header content");
        }
        String prefix = chunks[0];
        String tokenPart = chunks[1];
        if (BEARER_TOKEN_PREFIX.equals(prefix)) {
            if (tokenPart == null || tokenPart.trim().equals("")) {
                throw new OAuthInvalidAuthzHeaderException("Invalid Authorization header content");
            }
            return tokenPart;
        }
        throw new OAuthInvalidAuthzHeaderException("Unrecognized Access Token Type");
    }
}

