/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.impl;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.sap.cloud.security.oauth2.OAuthSystemException;
import com.sap.cloud.security.oauth2.commons.LoggerHelper;
import com.sap.cloud.security.oauth2.commons.exception.OAuthProblemException;
import com.sap.cloud.security.oauth2.commons.token.AccessTokenInfo;
import com.sap.core.jpaas.security.utils.connection.Connection;
import com.sap.core.jpaas.security.utils.connection.ConnectionException;
import com.sap.core.jpaas.security.utils.connection.Request;
import com.sap.core.jpaas.security.utils.connection.Response;
import com.sap.core.jpaas.security.utils.connection.impl.DestinationURLConnection;
import com.sap.core.jpaas.security.utils.connection.impl.URLRequest;
import com.sap.core.tenant.api.Tenant;
import java.net.HttpURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientAuthorizationService {
    private static Logger logger = LoggerFactory.getLogger(ClientAuthorizationService.class);
    private static final String DESTINATION_NAME = "oauth";

    public AccessTokenInfo getAccessTokenInfo(String accessToken) throws OAuthSystemException, OAuthProblemException {
        if (accessToken == null || accessToken.trim().equals("")) {
            throw new OAuthProblemException("missing_access_token", "Access token is missing in the authorization header.");
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Request to check token [{}] in tenant [{}]", (Object)LoggerHelper.getTokenForLog((String)accessToken), (Object)this.getTenantId());
            }
            OAuthResponse response = this.fetchAccessToken(accessToken);
            logger.debug("Response from OAuth server: [{}]", (Object)response);
            int statusCode = response.getStatusCode();
            if (statusCode == 200) {
                return (AccessTokenInfo)new Gson().fromJson(response.getResponseContent(), new TypeToken<AccessTokenInfo>(){}.getType());
            }
            if (statusCode == 400) {
                logger.debug("Access token is missing in the authorization header");
                throw new OAuthProblemException("missing_access_token", "Access token is missing in the authorization header");
            }
            if (statusCode == 401) {
                logger.debug("There is not such access token registered or it has been already expired");
                throw new OAuthProblemException("invalid_access_token", "There is not such access token registered or it has been already expired");
            }
            if (statusCode == 500) {
                logger.debug("Internal server error while executing HTTP request to the Authorization Server for retrieving of access token info");
                throw new OAuthSystemException("Internal server error while executing HTTP request to the Authorization Server for retrieving access token info");
            }
            logger.debug("Unexpected error occur while executing HTTP request to the Authorization Server for retrieving of access token info. Status code: [{}]", (Object)statusCode);
            throw new OAuthSystemException(String.valueOf(statusCode) + " - Internal server error while executing HTTP request to the Authorization Server for retrieving access token info");
        }
        catch (ConnectionException exception) {
            logger.error("Exception while executing HTTP request to the Authorization Server.", (Throwable)exception);
            throw new OAuthSystemException("Exception while executing HTTP request to the Authorization Server.", (Throwable)exception);
        }
    }

    String getTenantId() {
        return Tenant.getId();
    }

    private OAuthResponse fetchAccessToken(String accessToken) {
        Connection<HttpURLConnection> connection = this.createConnection();
        Response response = null;
        try {
            response = connection.execute((Request)this.createRequest(accessToken));
            if (response.isNotOK()) {
                OAuthResponse oAuthResponse = new OAuthResponse(response.getStatus());
                return oAuthResponse;
            }
            OAuthResponse oAuthResponse = new OAuthResponse(response.getStatus(), response.asString());
            return oAuthResponse;
        }
        finally {
            if (response != null) {
                response.consume();
            }
        }
    }

    Connection<HttpURLConnection> createConnection() {
        return new DestinationURLConnection(DESTINATION_NAME);
    }

    private URLRequest createRequest(String accessToken) {
        return (URLRequest)new URLRequest.Builder().withQueryParam("tenant_id", this.getTenantId()).withHeader("access_token", accessToken).withContentType("application/x-www-form-urlencoded").withGETMethod().build();
    }

    public static class OAuthResponse {
        private int statusCode;
        private String responseContent;

        public OAuthResponse(int statusCode) {
            this(statusCode, null);
        }

        public OAuthResponse(int statusCode, String responseContent) {
            this.statusCode = statusCode;
            this.responseContent = responseContent;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getResponseContent() {
            return this.responseContent;
        }

        public String toString() {
            return "OAuthResponse [statusCode=" + this.statusCode + ", responseContent=" + this.responseContent + "]";
        }
    }
}

