/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.impl;

import com.sap.cloud.security.oauth2.commons.LoggerHelper;
import com.sap.cloud.security.oauth2.commons.token.AccessTokenInfo;
import com.sap.cloud.security.oauth2.impl.CacheEntry;
import com.sap.cloud.security.oauth2.loginmodule.OAuth2JPaaSPrincipal;
import com.sap.cloud.security.oauth2.util.Encryptor;
import com.sap.core.tenant.api.Tenant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientAuthorizationServiceCache {
    private static final int CONCURRENCY_LEVEL = 30;
    private static final float LOAD_FACTOR = 0.75f;
    private static final int INITIAL_CAPACITY = 20;
    private static final int TWO_MINUTES_MS = 120000;
    private static final int TEN_MINUTES_MS = 600000;
    private Map<String, CacheEntry> cache = new ConcurrentHashMap<String, CacheEntry>(20, 0.75f, 30);
    protected long lastCacheCleanup = System.currentTimeMillis();
    private int cachingTimeMs = 120000;
    private static Encryptor encryptor = new Encryptor();
    private static final Logger logger = LoggerFactory.getLogger(ClientAuthorizationServiceCache.class);

    public AccessTokenInfo getAccessTokenInfo(String tokenId) {
        CacheEntry cacheEntry = this.getCacheEntry(tokenId);
        if (cacheEntry != null) {
            return cacheEntry.getAccessTokenInfo();
        }
        return null;
    }

    public OAuth2JPaaSPrincipal getOAuthPrincipal(String tokenId) {
        CacheEntry cacheEntry = this.getCacheEntry(tokenId);
        if (cacheEntry != null) {
            return cacheEntry.getOAuthPrincipal();
        }
        return null;
    }

    public void addCacheEntry(String tokenId, AccessTokenInfo accessTokenInfo) {
        this.addCacheEntry(tokenId, accessTokenInfo, null);
    }

    public void addCacheEntry(String tokenId, AccessTokenInfo accessTokenInfo, OAuth2JPaaSPrincipal oAuthPrincipal) {
        if (accessTokenInfo == null || this.isTokenExpired(accessTokenInfo)) {
            return;
        }
        logger.debug("Putting AccessTokenInfo [{}] and OAuth2JPaaSPrincipal [{}] in cache for token id [{}]", new Object[]{accessTokenInfo, oAuthPrincipal, LoggerHelper.getTokenForLog((String)tokenId)});
        String encryptedId = this.getEncryptedTokenId(tokenId);
        CacheEntry accessTokenInfoCached = this.cache.get(encryptedId);
        if (accessTokenInfoCached == null) {
            accessTokenInfoCached = new CacheEntry(accessTokenInfo, this.getCurrentTenantId());
            accessTokenInfoCached.setOAuthPrincipal(oAuthPrincipal);
            this.cache.put(encryptedId, accessTokenInfoCached);
        } else if (accessTokenInfoCached.getOAuthPrincipal() == null && oAuthPrincipal != null) {
            accessTokenInfoCached.setOAuthPrincipal(oAuthPrincipal);
            this.cache.put(encryptedId, accessTokenInfoCached);
        }
    }

    public void setCachingTime(int cachingTimeMs) {
        this.cachingTimeMs = cachingTimeMs;
    }

    private CacheEntry getCacheEntry(String tokenId) {
        String encryptedTokenId;
        if (this.lastCacheCleanup + 600000L <= System.currentTimeMillis()) {
            this.cleanCacheFromExpiredRecords();
        }
        if ((encryptedTokenId = this.getEncryptedTokenId(tokenId)) == null) {
            return null;
        }
        CacheEntry cacheEntry = this.cache.get(encryptedTokenId);
        if (cacheEntry == null) {
            logger.debug("No cached data found for token id [{}]", (Object)LoggerHelper.getTokenForLog((String)tokenId));
            return null;
        }
        String currentTenant = this.getCurrentTenantId();
        if (!currentTenant.equals(cacheEntry.getTenantId())) {
            logger.debug("Cached access token [{}] is issued for tenant [{}] but current tenant is [{}]. Will not use the cached token", new Object[]{LoggerHelper.getTokenForLog((String)tokenId), cacheEntry.getTenantId(), currentTenant});
            return null;
        }
        AccessTokenInfo accessTokenInfo = cacheEntry.getAccessTokenInfo();
        if (this.isTokenExpired(accessTokenInfo) || this.isCacheEntryExpired(cacheEntry)) {
            this.cache.remove(encryptedTokenId);
            return null;
        }
        logger.debug("Entry [{}] returned from cache with [{}], [{}]", new Object[]{LoggerHelper.getTokenForLog((String)tokenId), cacheEntry.getAccessTokenInfo(), cacheEntry.getOAuthPrincipal()});
        return cacheEntry;
    }

    private void cleanCacheFromExpiredRecords() {
        for (Map.Entry<String, CacheEntry> entry : this.cache.entrySet()) {
            if (!this.isCacheEntryExpired(entry.getValue())) continue;
            this.cache.remove(entry.getKey());
        }
        this.updateLastCleanupTime();
    }

    protected void updateLastCleanupTime() {
        this.lastCacheCleanup = System.currentTimeMillis();
    }

    private boolean isCacheEntryExpired(CacheEntry cacheEntry) {
        return cacheEntry.getCachedTime() + (long)this.cachingTimeMs < System.currentTimeMillis();
    }

    private String getEncryptedTokenId(String tokenId) {
        if (tokenId == null) {
            return null;
        }
        try {
            return encryptor.encrypt(tokenId);
        }
        catch (Encryptor.EncryptionException e) {
            logger.error("Error during token id encryption for cache. May result in cache malfuntion and performance issues.", (Throwable)e);
            return null;
        }
    }

    private boolean isTokenExpired(AccessTokenInfo accessTokenInfo) {
        int expiresInSec = accessTokenInfo.getExpiresin();
        long issuedAt = accessTokenInfo.getIssuedat();
        if (expiresInSec > 0) {
            long expiresAt = issuedAt + (long)(expiresInSec * 1000);
            long currentTime = System.currentTimeMillis();
            return expiresAt < currentTime;
        }
        return false;
    }

    String getCurrentTenantId() {
        return Tenant.getId();
    }

    public int getSize() {
        return this.cache.size();
    }
}

