/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.impl;

import com.sap.cloud.security.oauth2.OAuthSystemException;
import com.sap.cloud.security.oauth2.commons.exception.OAuthProblemException;
import com.sap.cloud.security.oauth2.commons.token.AccessTokenInfo;
import com.sap.cloud.security.oauth2.impl.ClientAuthorizationService;
import com.sap.cloud.security.oauth2.impl.ClientAuthorizationServiceCache;
import com.sap.cloud.security.oauth2.loginmodule.OAuth2JPaaSPrincipal;

public class ClientAuthorizationServiceCacheFacade {
    private static ClientAuthorizationServiceCacheFacade instance;
    private ClientAuthorizationServiceCache cache;

    ClientAuthorizationServiceCacheFacade() {
        this(new ClientAuthorizationServiceCache());
    }

    ClientAuthorizationServiceCacheFacade(ClientAuthorizationServiceCache cache) {
        this.cache = cache;
    }

    public static ClientAuthorizationServiceCacheFacade getInstance() {
        if (instance == null) {
            instance = new ClientAuthorizationServiceCacheFacade();
        }
        return instance;
    }

    public AccessTokenInfo retrieveAssessTokenInfo(String tokenId, boolean doCache) throws OAuthSystemException, OAuthProblemException {
        ClientAuthorizationService authzService;
        AccessTokenInfo accessTokenInfo = this.cache.getAccessTokenInfo(tokenId);
        if (accessTokenInfo == null && (accessTokenInfo = (authzService = this.createClientAuthorizationService()).getAccessTokenInfo(tokenId)) != null && doCache) {
            this.cache.addCacheEntry(tokenId, accessTokenInfo);
        }
        return accessTokenInfo;
    }

    public OAuth2JPaaSPrincipal retrieveCachedOauthPrinciple(String tokenId) throws OAuthSystemException, OAuthProblemException {
        return this.cache.getOAuthPrincipal(tokenId);
    }

    public void cacheOauthPrinciple(String tokenId, AccessTokenInfo accessTokenInfo, OAuth2JPaaSPrincipal principal) throws OAuthSystemException, OAuthProblemException {
        this.cache.addCacheEntry(tokenId, accessTokenInfo, principal);
    }

    ClientAuthorizationService createClientAuthorizationService() {
        return new ClientAuthorizationService();
    }
}

