/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.impl;

import com.sap.cloud.security.oauth2.OAuthAuthorization;
import com.sap.cloud.security.oauth2.OAuthSystemException;
import com.sap.cloud.security.oauth2.commons.exception.OAuthProblemException;
import com.sap.cloud.security.oauth2.util.OAuthPrincipalExtractor;
import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthAuthorizationFilterImpl
implements Filter {
    Set<String> scopes;
    Set<String> httpMethods;
    private boolean userPrincipal;
    private boolean doDestroySession;
    private static final Logger logger = LoggerFactory.getLogger(OAuthAuthorizationFilterImpl.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        boolean isAthorize = false;
        String httpMethod = httpRequest.getMethod();
        if (!this.isHttpMethodAccepted(httpMethod)) {
            logger.debug("httpMethod {} is not accepted. The OAuth filter will be skiped", (Object)httpMethod);
            chain.doFilter(request, response);
            return;
        }
        try {
            OAuthAuthorization authorization = this.getOAuthAuthorizationService();
            if (authorization == null) {
                throw new OAuthSystemException("Couldn't get OAuthAuthorizationService object.");
            }
            isAthorize = authorization.isAuthorized(httpRequest, this.scopes);
        }
        catch (OAuthSystemException e) {
            this.handleError(httpResponse, (Exception)((Object)e), 500);
            return;
        }
        if (isAthorize) {
            if (this.userPrincipal) {
                String userid = (String)httpRequest.getAttribute("user_id");
                logger.debug("user_principal is true. getUserPrincipal method has to return the user from the token.");
                OAuthRequestWrapper requestWrapper = new OAuthRequestWrapper(userid, httpRequest);
                chain.doFilter((ServletRequest)requestWrapper, (ServletResponse)httpResponse);
            } else {
                chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            }
            this.destroySessionIfConfigured(httpRequest);
            return;
        }
        this.destroySessionIfConfigured(httpRequest);
        Object reasonAttribute = httpRequest.getAttribute("reason");
        if (reasonAttribute != null && ((String)reasonAttribute).equals("access_forbidden")) {
            httpResponse.sendError(403);
            return;
        }
        httpResponse.sendError(401);
    }

    private boolean isHttpMethodAccepted(String httpMethod) {
        if (this.httpMethods == null || httpMethod == null) {
            logger.debug("httpMethods = {} , httpMethod = {}" + this.httpMethods, (Object)httpMethod);
            return false;
        }
        if (this.httpMethods.isEmpty()) {
            return true;
        }
        for (String currentMethod : this.httpMethods) {
            if (!currentMethod.equalsIgnoreCase(httpMethod)) continue;
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Exit with false. httpMethods=" + Arrays.toString(this.httpMethods.toArray(new String[0])));
        }
        return false;
    }

    private void destroySessionIfConfigured(HttpServletRequest httpRequest) {
        if (this.doDestroySession) {
            OAuthPrincipalExtractor extractor = this.getPrincipalExtractor(httpRequest);
            try {
                extractor.getPrincipal();
                HttpSession session = httpRequest.getSession();
                if (session != null) {
                    logger.debug("Current session will be invalidated");
                    session.invalidate();
                }
            }
            catch (OAuthProblemException e) {
                logger.debug("Cannot extract user principal but as the session is not OAuth we will not destroy the session", (Throwable)e);
            }
        }
    }

    private void handleError(HttpServletResponse httpResponse, Exception e, int responseCode) throws IOException {
        logger.error("Internal server error when checking the authorization. " + e.getMessage(), (Throwable)e);
        httpResponse.sendError(responseCode);
    }

    public void init(FilterConfig config) throws ServletException {
        this.debugConfiguration(config);
        String scopeParam = config.getInitParameter("scope");
        this.scopes = new HashSet<String>();
        if (scopeParam != null) {
            String[] scopeArray = scopeParam.split(" ");
            Collections.addAll(this.scopes, scopeArray);
        }
        String httpMethodParam = config.getInitParameter("http-method");
        this.httpMethods = new HashSet<String>();
        if (httpMethodParam != null) {
            String[] httpMethodsArray = httpMethodParam.split(" ");
            Collections.addAll(this.httpMethods, httpMethodsArray);
        }
        this.userPrincipal = new Boolean(config.getInitParameter("user-principal"));
        this.doDestroySession = new Boolean(config.getInitParameter("no-session"));
    }

    public void destroy() {
        this.scopes = null;
        this.httpMethods = null;
        this.userPrincipal = false;
        this.doDestroySession = false;
    }

    OAuthAuthorization getOAuthAuthorizationService() {
        return OAuthAuthorization.getOAuthAuthorizationService();
    }

    OAuthPrincipalExtractor getPrincipalExtractor(HttpServletRequest httpRequest) {
        return new OAuthPrincipalExtractor(httpRequest);
    }

    private void debugConfiguration(FilterConfig config) {
        if (logger.isDebugEnabled()) {
            String result = "Filter configuration: [";
            Enumeration initParameterNames = config.getInitParameterNames();
            while (initParameterNames != null && initParameterNames.hasMoreElements()) {
                String parameterName = (String)initParameterNames.nextElement();
                result = String.valueOf(result) + "{" + parameterName + " : " + config.getInitParameter(parameterName) + "}";
            }
            result = String.valueOf(result) + "]";
            logger.debug(result);
        }
    }

    class OAuthRequestWrapper
    extends HttpServletRequestWrapper {
        private String userid;

        public OAuthRequestWrapper(String userid, HttpServletRequest request) {
            super(request);
            this.userid = userid;
        }

        public Principal getUserPrincipal() {
            return new Principal(){

                @Override
                public String getName() {
                    return OAuthRequestWrapper.this.userid;
                }
            };
        }

        public String getRemoteUser() {
            return this.userid;
        }

        public boolean isUserInRole(String role) {
            return false;
        }
    }
}

