/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.impl;

import com.sap.cloud.security.oauth2.OAuthAuthorization;
import com.sap.cloud.security.oauth2.OAuthSystemException;
import com.sap.cloud.security.oauth2.commons.exception.OAuthInvalidAuthzHeaderException;
import com.sap.cloud.security.oauth2.commons.exception.OAuthProblemException;
import com.sap.cloud.security.oauth2.commons.token.AccessTokenInfo;
import com.sap.cloud.security.oauth2.impl.AccessTokenParser;
import com.sap.cloud.security.oauth2.impl.ClientAuthorizationServiceCacheFacade;
import com.sap.cloud.security.oauth2.util.OAuthPrincipalExtractor;
import com.sap.security.um.service.UserManagementAccessor;
import com.sap.security.um.user.PersistenceException;
import com.sap.security.um.user.User;
import com.sap.security.um.user.UserProvider;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthAuthorizationImpl
extends OAuthAuthorization {
    private static final Logger logger = LoggerFactory.getLogger(OAuthAuthorizationImpl.class);

    public boolean isAuthorized(HttpServletRequest httpRequest) throws OAuthSystemException {
        HashSet<String> scopes = new HashSet<String>();
        return this.isAuthorized(httpRequest, scopes);
    }

    public boolean isAuthorized(HttpServletRequest httpRequest, String scope) throws OAuthSystemException {
        if (scope == null) {
            return this.isAuthorized(httpRequest);
        }
        HashSet<String> scopes = new HashSet<String>();
        scopes.add(scope);
        return this.isAuthorized(httpRequest, scopes);
    }

    public boolean isAuthorized(String scope) throws OAuthSystemException {
        HashSet<String> scopes = new HashSet<String>();
        if (scope != null && !scope.equals("")) {
            scopes.add(scope);
        }
        return this.isAuthorized(scopes);
    }

    public boolean isAuthorized(Set<String> requiredScopes) throws OAuthSystemException {
        HashSet<Object> grantedScopes = null;
        if (requiredScopes == null) {
            requiredScopes = new HashSet<String>();
        }
        User user = null;
        try {
            user = this.getUser();
            if (user != null) {
                Set userAttributes = user.listAttributes();
                if (userAttributes.contains("com.sap.security.oauth2.clientId")) {
                    String[] scopesFromLoggedInUser = user.getAttributeValues("com.sap.security.oauth2.grantedScopes");
                    grantedScopes = scopesFromLoggedInUser == null ? new HashSet() : new HashSet<String>(Arrays.asList(scopesFromLoggedInUser));
                    return this.checkScopes(grantedScopes, requiredScopes);
                }
                logger.debug("The session is not OAuth we will allow the request");
                return true;
            }
        }
        catch (PersistenceException e) {
            logger.debug("There is no loggin user. The scopes will be checked against access token.", (Throwable)e);
        }
        return false;
    }

    public boolean isAuthorized(HttpServletRequest httpRequest, Set<String> scopes) throws OAuthSystemException {
        block3: {
            block4: {
                if (this.getUser() == null) break block3;
                if (!this.isAuthorized(scopes)) break block4;
                return true;
            }
            try {
                httpRequest.setAttribute("reason", (Object)"access_forbidden");
                return false;
            }
            catch (PersistenceException e) {
                logger.debug("There is no loggin user. The scopes will be checked against access token.", (Throwable)e);
            }
        }
        return this.isAccessTokenAuthorized(httpRequest, scopes);
    }

    ClientAuthorizationServiceCacheFacade initCache() {
        return ClientAuthorizationServiceCacheFacade.getInstance();
    }

    OAuthPrincipalExtractor getPrincipalExtractor(HttpServletRequest httpRequest) {
        return new OAuthPrincipalExtractor(httpRequest);
    }

    private boolean checkScopes(Set<String> grantedScopes, Set<String> requiredScopes) {
        if (requiredScopes == null || requiredScopes.isEmpty()) {
            return true;
        }
        for (String scope : requiredScopes) {
            if (grantedScopes != null && grantedScopes.contains(scope)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Required scope [" + scope + "] is not found in granted scopes [" + this.setToString(grantedScopes) + "]");
            }
            return false;
        }
        return true;
    }

    private String setToString(Set<String> set) {
        String result = "";
        if (set.isEmpty()) {
            return "";
        }
        for (String element : set) {
            result = String.valueOf(result) + element + ", ";
        }
        return result.substring(0, result.length() - 2);
    }

    User getUser() throws PersistenceException {
        UserProvider userProvider = UserManagementAccessor.getUserProvider();
        return userProvider.getCurrentUser();
    }

    private boolean isAccessTokenAuthorized(HttpServletRequest httpRequest, Set<String> scopes) throws OAuthSystemException {
        String token;
        Set grantedScopes = null;
        AccessTokenInfo accessTokenInfo = null;
        try {
            token = AccessTokenParser.parse(httpRequest);
        }
        catch (OAuthInvalidAuthzHeaderException e) {
            httpRequest.setAttribute("reason", (Object)"missing_access_token");
            logger.debug("Assess token is missing in the authorization header.", (Throwable)e);
            return false;
        }
        try {
            accessTokenInfo = this.initCache().retrieveAssessTokenInfo(token, true);
        }
        catch (OAuthProblemException e) {
            httpRequest.setAttribute("reason", (Object)e.getCode());
            logger.debug(e.getMessage(), (Throwable)e);
            return false;
        }
        if (accessTokenInfo == null) {
            httpRequest.setAttribute("reason", (Object)"access_forbidden");
            logger.debug("Access is forbidden. The token is null.");
            return false;
        }
        grantedScopes = accessTokenInfo.getScopes();
        if (this.checkScopes(grantedScopes, scopes)) {
            httpRequest.setAttribute("user_id", (Object)accessTokenInfo.getUserid());
            httpRequest.setAttribute("client_id", (Object)accessTokenInfo.getClientid());
            return true;
        }
        httpRequest.setAttribute("reason", (Object)"access_forbidden");
        logger.debug("Access is forbidden. Scopes are not granted");
        return false;
    }
}

