/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.loginmodule;

import com.sap.cloud.security.oauth2.OAuthSystemException;
import com.sap.cloud.security.oauth2.commons.code.GrantType;
import com.sap.cloud.security.oauth2.commons.exception.OAuthProblemException;
import com.sap.cloud.security.oauth2.commons.token.AccessTokenInfo;
import com.sap.cloud.security.oauth2.commons.token.UserInfo;
import com.sap.cloud.security.oauth2.impl.ClientAuthorizationServiceCacheFacade;
import com.sap.cloud.security.oauth2.loginmodule.OAuth2JPaaSPrincipal;
import com.sap.cloud.security.oauth2.loginmodule.OAuth2JPaaSPrincipalManager;
import com.sap.cloud.security.oauth2.loginmodule.OAuthTokenExtractor;
import com.sap.core.jpaas.security.saml2.sp.exception.SAML2JPaaSException;
import com.sap.security.saml2.commons.Attribute;
import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2JPaaSLoginModule
implements LoginModule {
    private static final String PREFIX_CLIENT_CREDENTIALS_FLOW_USER = "oauth_client_";
    private Subject subject;
    private CallbackHandler callbackHandler;
    private String token;
    private OAuth2JPaaSPrincipal oAuth2JPaaSPrincipal;
    private OAuth2JPaaSPrincipalManager oAuth2PrincipalManager;
    private OAuth2JPaaSLoginModuleInitializer initializer;
    private OAuthTokenExtractor oAuthTokenExtractor;
    private static final Logger logger = LoggerFactory.getLogger(OAuth2JPaaSLoginModule.class);

    public OAuth2JPaaSLoginModule() {
        this.initializer = new OAuth2JPaaSLoginModuleInitializer();
    }

    OAuth2JPaaSLoginModule(OAuth2JPaaSLoginModuleInitializer initializer) {
        this.initializer = initializer;
        this.subject = new Subject();
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        logger.debug("OAuth2JPaaSLoginModule initialize");
        this.callbackHandler = callbackHandler;
        this.subject = subject;
        this.oAuthTokenExtractor = this.initializer.getOAuthTokenExtractorInstance(this.callbackHandler);
        this.oAuth2PrincipalManager = this.initializer.getPrincipalManagerInstance();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean login() throws LoginException {
        logger.debug("OAuth2JPaaSLoginModule entering login()");
        try {
            this.token = this.oAuthTokenExtractor.extractToken();
        }
        catch (IOException e) {
            this.processError(e.getMessage(), e);
        }
        if (this.token == null) {
            this.processError("OAuth2JPaaSLoginModule - Assess token is missing in the authorization header");
        }
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        try {
            ClientAuthorizationServiceCacheFacade cacheFacde = this.initializer.getClientAuthorizationServiceCacheFacadeInstance();
            this.oAuth2JPaaSPrincipal = cacheFacde.retrieveCachedOauthPrinciple(this.token);
            if (this.oAuth2JPaaSPrincipal != null) return true;
            AccessTokenInfo accessTokenInfo = cacheFacde.retrieveAssessTokenInfo(this.token, false);
            String userName = accessTokenInfo.getUserid();
            String idpName = null;
            if (userName == null) {
                if (accessTokenInfo.getGrantType() != GrantType.CLIENTGRANT) {
                    logger.error("Authentication failed - access token info retrieved from oauth server contains no user name and the grant type is not client_credentials");
                    throw new LoginException("Authentication failed - access token info retrieved from oauth server contains no user name and the grant type is not client_credentials.");
                }
                userName = PREFIX_CLIENT_CREDENTIALS_FLOW_USER + accessTokenInfo.getClientid();
            } else {
                UserInfo userInfo = accessTokenInfo.getUserInfo();
                if (userInfo != null) {
                    idpName = userInfo.getIdpName();
                    for (Map.Entry attributeEntry : userInfo.getAttributes().entrySet()) {
                        String attributeKey = (String)attributeEntry.getKey();
                        List attributeValues = (List)attributeEntry.getValue();
                        if (attributeKey == null || attributeValues == null) continue;
                        attributes.add(new Attribute(null, attributeKey, attributeValues));
                    }
                }
            }
            this.oAuth2JPaaSPrincipal = this.oAuth2PrincipalManager.createOAuth2JPaaSPrincipal(userName, attributes, idpName, accessTokenInfo.getScopes(), accessTokenInfo.getClientid());
            cacheFacde.cacheOauthPrinciple(this.token, accessTokenInfo, this.oAuth2JPaaSPrincipal);
            return true;
        }
        catch (OAuthSystemException e) {
            this.processError("Could not retrieve token info from the server.", (Exception)((Object)e));
            return true;
        }
        catch (OAuthProblemException e) {
            this.processError("Could not retrieve token info from the server.", (Exception)((Object)e));
            return true;
        }
        catch (SAML2JPaaSException e) {
            this.processError("Could not create the OAuth principal object.", (Exception)((Object)e));
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        logger.debug("OAuth2JPaaSLoginModule entering commit()");
        if (this.oAuth2JPaaSPrincipal != null) {
            boolean isUserUpdated;
            if (logger.isDebugEnabled()) {
                logger.debug("OAuth2JPaaSLoginModule commit():  {} is about to be added to subject.", (Object)this.oAuth2JPaaSPrincipal);
            }
            if (!(isUserUpdated = this.oAuth2PrincipalManager.updateUser(this.oAuth2JPaaSPrincipal))) {
                String errorMessage = "Could not update user with data from OAuth Authorization server. Authentication for user " + this.oAuth2JPaaSPrincipal.getName() + " failed.";
                this.processError(errorMessage);
            }
            this.subject.getPrincipals().add((Principal)((Object)this.oAuth2JPaaSPrincipal));
            if (logger.isDebugEnabled()) {
                logger.debug("OAuth2JPaaSLoginModule commit(): {} was added to subject.", (Object)this.oAuth2JPaaSPrincipal);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean abort() throws LoginException {
        logger.debug("OAuth2JPaaSLoginModule entering abort()");
        if (this.oAuth2JPaaSPrincipal != null) {
            this.subject.getPrincipals().remove(this.oAuth2JPaaSPrincipal);
            this.oAuth2JPaaSPrincipal = null;
            logger.debug("OAuth2 principal removed from subject");
            return true;
        }
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        logger.debug("OAuth2JPaaSLoginModule entering logout()");
        Set<OAuth2JPaaSPrincipal> oauth2Principals = this.subject.getPrincipals(OAuth2JPaaSPrincipal.class);
        if (!oauth2Principals.isEmpty()) {
            for (OAuth2JPaaSPrincipal oauth2Principal : oauth2Principals) {
                this.subject.getPrincipals().remove(oauth2Principal);
            }
            logger.debug("OAuth2 principal removed from subject");
        }
        return true;
    }

    private void processError(String errorMessage) throws LoginException {
        this.processError(errorMessage, null);
    }

    private void processError(String errorMessage, Exception e) throws LoginException {
        if (e == null) {
            logger.info(errorMessage);
        } else {
            logger.info(errorMessage, (Throwable)e);
        }
        LoginException loginEx = new LoginException(errorMessage);
        if (e != null) {
            loginEx.initCause(e);
        }
        throw loginEx;
    }

    public class OAuth2JPaaSLoginModuleInitializer {
        public OAuth2JPaaSPrincipalManager getPrincipalManagerInstance() {
            return new OAuth2JPaaSPrincipalManager();
        }

        public OAuthTokenExtractor getOAuthTokenExtractorInstance(CallbackHandler callbackHandler) {
            return new OAuthTokenExtractor(callbackHandler);
        }

        public ClientAuthorizationServiceCacheFacade getClientAuthorizationServiceCacheFacadeInstance() {
            return ClientAuthorizationServiceCacheFacade.getInstance();
        }
    }
}

