/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.loginmodule;

import com.sap.cloud.security.oauth2.loginmodule.OAuth2JPaaSPrincipal;
import com.sap.core.jpaas.security.saml2.service.cfg.SAML2ConfigurationJPaaSImpl;
import com.sap.core.jpaas.security.saml2.service.cfg.SAML2JPaaSConfigurationReader;
import com.sap.core.jpaas.security.saml2.service.cfg.SAML2TrustedIdPJPaaSImpl;
import com.sap.core.jpaas.security.saml2.sp.exception.SAML2JPaaSException;
import com.sap.core.jpaas.security.saml2.sp.util.UMHelper;
import com.sap.core.jpaas.security.saml2.sp.util.UserAttribute;
import com.sap.security.saml2.commons.Attribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OAuth2JPaaSPrincipalManager {
    private UMFactoryHelper umHelper = null;
    private SAML2JPaaSConfigurationReaderFactoryHelper configurationReader = null;

    public OAuth2JPaaSPrincipalManager() {
        this.umHelper = new UMFactoryHelper();
        this.configurationReader = new SAML2JPaaSConfigurationReaderFactoryHelper();
    }

    OAuth2JPaaSPrincipalManager(UMFactoryHelper umHelper, SAML2JPaaSConfigurationReaderFactoryHelper configurationReader) {
        this.umHelper = umHelper;
        this.configurationReader = configurationReader;
    }

    public OAuth2JPaaSPrincipal createOAuth2JPaaSPrincipal(String principalName, Set<Attribute> attributes, String idpName, Set<String> scopes, String clientId) throws SAML2JPaaSException {
        List<UserAttribute> userAttributes = new ArrayList<UserAttribute>();
        HashSet<String> allUserGroups = new HashSet<String>();
        SAML2TrustedIdPJPaaSImpl idp = this.getSAML2TrustedIdP(idpName);
        if (attributes != null && idp != null) {
            Map<String, Attribute> assertionAttributes = this.umHelper.organizeSAMLPrincipalAttributes(attributes);
            userAttributes = this.umHelper.calculateUserAttributes(assertionAttributes, idp);
            allUserGroups = this.umHelper.calculateUserGroups(assertionAttributes, idp);
        }
        if (clientId != null) {
            ArrayList<String> clientIdList = new ArrayList<String>(1);
            clientIdList.add(clientId);
            userAttributes.add(new UserAttribute("com.sap.security.oauth2.clientId", clientIdList));
        }
        ArrayList<String> scopesList = new ArrayList<String>();
        if (scopes != null) {
            scopesList.addAll(scopes);
            userAttributes.add(new UserAttribute("com.sap.security.oauth2.grantedScopes", scopesList));
        }
        return new OAuth2JPaaSPrincipal(principalName, userAttributes, allUserGroups, scopes, clientId);
    }

    public boolean updateUser(OAuth2JPaaSPrincipal oAuth2JPaaSPrincipal) {
        String name = oAuth2JPaaSPrincipal.getName();
        List<UserAttribute> attributes = oAuth2JPaaSPrincipal.getUserAttributes();
        Set<String> groups = oAuth2JPaaSPrincipal.getUserGroups();
        return this.umHelper.updateUser(name, attributes, groups);
    }

    SAML2TrustedIdPJPaaSImpl getSAML2TrustedIdP(String idpName) {
        if (idpName == null) {
            return null;
        }
        SAML2JPaaSConfigurationReader cfgReader = this.configurationReader.getConfigurationFileReader();
        SAML2ConfigurationJPaaSImpl saml2Config = cfgReader.getConfiguration();
        SAML2TrustedIdPJPaaSImpl saml2TrustedIdP = saml2Config.getTrustedIdP(idpName);
        return saml2TrustedIdP;
    }

    public class SAML2JPaaSConfigurationReaderFactoryHelper {
        public SAML2JPaaSConfigurationReader getConfigurationFileReader() {
            return SAML2JPaaSConfigurationReader.getConfigurationFileReader();
        }
    }

    public class UMFactoryHelper {
        public Map<String, Attribute> organizeSAMLPrincipalAttributes(Set<Attribute> attributes) {
            return UMHelper.organizeSAMLPrincipalAttributes(attributes);
        }

        public boolean updateUser(String userName, List<UserAttribute> attributes, Set<String> groups) {
            return UMHelper.updateUser((String)userName, attributes, groups);
        }

        public List<UserAttribute> calculateUserAttributes(Map<String, Attribute> assertionAttributes, SAML2TrustedIdPJPaaSImpl idp) throws SAML2JPaaSException {
            return UMHelper.calculateUserAttributes(assertionAttributes, (SAML2TrustedIdPJPaaSImpl)idp);
        }

        public HashSet<String> calculateUserGroups(Map<String, Attribute> assertionAttributes, SAML2TrustedIdPJPaaSImpl idp) {
            return UMHelper.calculateUserGroups(assertionAttributes, (SAML2TrustedIdPJPaaSImpl)idp);
        }
    }
}

