/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2.util;

import com.sap.cloud.security.oauth2.commons.PrincipalExtractor;
import com.sap.cloud.security.oauth2.commons.exception.OAuthProblemException;
import com.sap.cloud.security.oauth2.loginmodule.OAuth2JPaaSPrincipal;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;

public class OAuthPrincipalExtractor
extends PrincipalExtractor {
    public OAuthPrincipalExtractor(HttpServletRequest request) {
        super(request);
    }

    public OAuth2JPaaSPrincipal getPrincipal() throws OAuthProblemException {
        Principal principal = this.getPrincipalFromSuper();
        if (!OAuth2JPaaSPrincipal.class.isAssignableFrom(principal.getClass())) {
            logger.warn("Unrecognised principal class " + principal.getClass().getCanonicalName());
            throw new OAuthProblemException("Cannot extract OAuth Principal.");
        }
        return (OAuth2JPaaSPrincipal)((Object)principal);
    }

    Principal getPrincipalFromSuper() throws OAuthProblemException {
        return super.getPrincipal();
    }
}

