/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.lm.sl.slp.client;

import com.sap.cloud.lm.sl.slp.client.HttpClientException;
import com.sap.cloud.lm.sl.slp.client.ISlpManagementClient;
import com.sap.cloud.lm.sl.slp.client.ISlpProcessClient;
import com.sap.cloud.lm.sl.slp.client.SlpManagementClient;
import com.sap.cloud.lm.sl.slp.client.SlpProcessClient;
import com.sap.cloud.lm.sl.slp.client.communication.CsrfHttpClient;
import java.net.ProxySelector;
import java.util.Arrays;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class SlpClientFactory {
    private static final SlpClientFactory INSTANCE = new SlpClientFactory();
    private static final int DEFAULT_SOCKET_TIMEOUT = 180000;
    private static final int DEFAULT_CONNECT_TIMEOUT = 120000;

    private SlpClientFactory() {
    }

    public static SlpClientFactory getInstance() {
        return INSTANCE;
    }

    public ISlpManagementClient createManagementClient(String slpBaseUrl, HttpClient httpClient) throws HttpClientException {
        return new SlpManagementClient(slpBaseUrl, httpClient);
    }

    public ISlpManagementClient createManagementClient(String slpBaseUrl, String accessTokenValue) throws HttpClientException {
        return this.createManagementClient(slpBaseUrl, this.buildHttpClient(slpBaseUrl, accessTokenValue));
    }

    public ISlpProcessClient createProcessClient(String slpBaseUrl, String processRootUrl, HttpClient httpClient) throws HttpClientException {
        return new SlpProcessClient(slpBaseUrl, processRootUrl, httpClient);
    }

    public ISlpProcessClient createProcessClient(String slpBaseUrl, String processRootUrl, String accessTokenValue) throws HttpClientException {
        return this.createProcessClient(slpBaseUrl, processRootUrl, this.buildHttpClient(slpBaseUrl, accessTokenValue));
    }

    private HttpClient buildHttpClient(String slpBaseUrl, String accessTokenValue) {
        PlainSocketFactory plainSocketFactory = new PlainSocketFactory();
        SSLSocketFactory sslSocketFactory = SSLSocketFactory.getSocketFactory();
        SchemeRegistry schemeRegistry = SchemeRegistryFactory.createDefault();
        Scheme http = new Scheme("http", 80, (SchemeSocketFactory)plainSocketFactory);
        schemeRegistry.register(http);
        Scheme https = new Scheme("https", 443, (SchemeSocketFactory)sslSocketFactory);
        schemeRegistry.register(https);
        ThreadSafeClientConnManager connectionManager = new ThreadSafeClientConnManager(schemeRegistry);
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)connectionManager);
        if (System.getProperty("http.nonProxyHosts") == null) {
            System.setProperty("http.nonProxyHosts", "");
        }
        httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(3, true));
        ProxySelectorRoutePlanner routePlanner = new ProxySelectorRoutePlanner(schemeRegistry, ProxySelector.getDefault());
        httpClient.setRoutePlanner((HttpRoutePlanner)routePlanner);
        HttpParams params = httpClient.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)120000);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)180000);
        params.setParameter("http.default-headers", Arrays.asList(new BasicHeader("Authorization", "bearer " + accessTokenValue)));
        return new CsrfHttpClient((HttpClient)httpClient, slpBaseUrl);
    }
}

