/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.lm.sl.slp.client;

import com.sap.cloud.lm.sl.slp.client.BaseSlpClient;
import com.sap.cloud.lm.sl.slp.client.HttpClientException;
import com.sap.cloud.lm.sl.slp.client.ISlpManagementClient;
import com.sap.cloud.lm.sl.slp.client.urls.SlpManagementUrlProvider;
import com.sap.lmsl.slp.ComponentVersion;
import com.sap.lmsl.slp.Files;
import com.sap.lmsl.slp.Metadata;
import com.sap.lmsl.slp.Process;
import com.sap.lmsl.slp.Processes;
import com.sap.lmsl.slp.Service;
import com.sap.lmsl.slp.Services;
import com.sap.lmsl.slp.Versions;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.http.client.HttpClient;

public class SlpManagementClient
extends BaseSlpClient
implements ISlpManagementClient {
    private SlpManagementUrlProvider urlProvider;

    public SlpManagementClient(String baseUrl, HttpClient httpClient) throws HttpClientException {
        super(httpClient);
        this.urlProvider = new SlpManagementUrlProvider(baseUrl);
        this.getMetadata();
    }

    @Override
    public List<Service> getServices() throws HttpClientException {
        return this.getHttpRequestExecutor().doGet(this.urlProvider.getServices(), Services.class).getService();
    }

    @Override
    public Service getService(String serviceId) throws HttpClientException {
        return this.getHttpRequestExecutor().doGet(this.urlProvider.getService(serviceId), Service.class);
    }

    @Override
    public Process createProcess(Process process) throws HttpClientException {
        return this.getHttpRequestExecutor().doPost(this.urlProvider.getServiceProcesses(process.getService()), process, Process.class);
    }

    @Override
    public Metadata getMetadata() throws HttpClientException {
        return this.getHttpRequestExecutor().doGet(this.urlProvider.getMetadata(), Metadata.class);
    }

    @Override
    public List<Process> getServiceProcesses(String serviceId) throws HttpClientException {
        return this.getHttpRequestExecutor().doGet(this.urlProvider.getServiceProcesses(serviceId), Processes.class).getProcess();
    }

    @Override
    public Process getServiceProcess(String serviceId, String processId) throws HttpClientException {
        return this.getHttpRequestExecutor().doGet(this.urlProvider.getServiceProcess(serviceId, processId), Process.class);
    }

    @Override
    public void deleteServiceProcess(String serviceId, String processId) throws HttpClientException {
    }

    @Override
    public List<ComponentVersion> getServiceVersions(String serviceId) throws HttpClientException {
        return this.getHttpRequestExecutor().doGet(this.urlProvider.getServiceVersions(serviceId), Versions.class).getComponentVersion();
    }

    @Override
    public List<com.sap.lmsl.slp.File> getServiceFiles(String serviceId) throws HttpClientException {
        return this.getHttpRequestExecutor().doGet(this.urlProvider.getServiceFiles(serviceId), Files.class).getFile();
    }

    @Override
    public List<com.sap.lmsl.slp.File> uploadServiceFiles(String serviceId, File ... files) throws HttpClientException {
        return this.getHttpRequestExecutor().doMultipartPost(this.urlProvider.getServiceFiles(serviceId), new ArrayList<File>(Arrays.asList(files)), Files.class).getFile();
    }

    @Override
    public List<com.sap.lmsl.slp.File> uploadServiceFile(String serviceId, InputStream fileContent) throws HttpClientException {
        return null;
    }

    @Override
    public void deleteServiceFiles(String serviceId) throws HttpClientException {
    }

    @Override
    public void deleteServiceFile(String serviceId, String fileId) throws HttpClientException {
    }

    @Override
    public List<Process> getProcesses() throws HttpClientException {
        return this.getHttpRequestExecutor().doGet(this.urlProvider.getProcesses(), Processes.class).getProcess();
    }

    @Override
    public Process getProcess(String processId) throws HttpClientException {
        return this.getHttpRequestExecutor().doGet(this.urlProvider.getProcess(processId), Process.class);
    }

    @Override
    public void deleteProcess(String processId) throws HttpClientException {
    }
}

