/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.lm.sl.slp.client;

import com.sap.cloud.lm.sl.slp.client.BaseSlpClient;
import com.sap.cloud.lm.sl.slp.client.HttpClientException;
import com.sap.cloud.lm.sl.slp.client.ISlpProcessClient;
import com.sap.cloud.lm.sl.slp.client.urls.SlpProcessUrlProvider;
import com.sap.lmsl.slp.Action;
import com.sap.lmsl.slp.Actions;
import com.sap.lmsl.slp.Breakpoint;
import com.sap.lmsl.slp.ComponentVersion;
import com.sap.lmsl.slp.Config;
import com.sap.lmsl.slp.Dialog;
import com.sap.lmsl.slp.Error;
import com.sap.lmsl.slp.Log;
import com.sap.lmsl.slp.Logs;
import com.sap.lmsl.slp.Metadata;
import com.sap.lmsl.slp.Monitor;
import com.sap.lmsl.slp.Parameter;
import com.sap.lmsl.slp.Property;
import com.sap.lmsl.slp.Task;
import com.sap.lmsl.slp.Tasklist;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.w3c.dom.Element;

public class SlpProcessClient
extends BaseSlpClient
implements ISlpProcessClient {
    private SlpProcessUrlProvider urlProvider;

    public SlpProcessClient(String baseUrl, String processRootUrl, HttpClient httpClient) throws HttpClientException {
        super(httpClient);
        this.urlProvider = new SlpProcessUrlProvider(baseUrl, processRootUrl);
        this.getMetadata();
    }

    @Override
    public Metadata getMetadata() throws HttpClientException {
        return this.getHttpRequestExecutor().doGet(this.urlProvider.getMetadata(), Metadata.class);
    }

    @Override
    public List<Task> getMonitor() throws HttpClientException {
        return this.getHttpRequestExecutor().doGet(this.urlProvider.getMonitor(), Monitor.class).getTask();
    }

    @Override
    public Task getMonitorTask(String taskId) throws HttpClientException {
        return null;
    }

    @Override
    public Error getMonitorTaskError(String taskId) throws HttpClientException {
        return null;
    }

    @Override
    public List<Log> getMonitorTaskLogs(String taskId) throws HttpClientException {
        return null;
    }

    @Override
    public List<Task> getTasklist() throws HttpClientException {
        return this.getHttpRequestExecutor().doGet(this.urlProvider.getTasklist(), Tasklist.class).getTask();
    }

    @Override
    public Task getTasklistTask(String taskId) throws HttpClientException {
        return this.getHttpRequestExecutor().doGet(this.urlProvider.getTasklistTask(taskId), Task.class);
    }

    @Override
    public Error getTasklistTaskError(String taskId) throws HttpClientException {
        return null;
    }

    @Override
    public List<Log> getTasklistTaskLogs(String taskId) throws HttpClientException {
        Task task = this.getTasklistTask(taskId);
        String logLink = task.getLogs();
        if (logLink != null) {
            return this.getHttpRequestExecutor().doGet(this.urlProvider.getTasklistLogs(taskId, logLink), Logs.class).getLog();
        }
        logLink = SlpProcessClient.getLogsAsExtension(task);
        if (logLink != null) {
            return this.getHttpRequestExecutor().doGet(this.urlProvider.getTasklistLogs(taskId, logLink), Logs.class).getLog();
        }
        return null;
    }

    private static String getLogsAsExtension(Task task) {
        return SlpProcessClient.getTaskExtension(task, "logs");
    }

    private static String getTaskExtension(Task task, String tagName) {
        List extensionElements = task.getAny();
        return SlpProcessClient.getExtension(extensionElements, tagName);
    }

    private static String getExtension(List<Element> extensionElements, String tagName) {
        for (Element element : extensionElements) {
            if (!element.getTagName().equals(tagName)) continue;
            return element.getTextContent();
        }
        return null;
    }

    @Override
    public List<Parameter> getConfig() throws HttpClientException {
        return this.getHttpRequestExecutor().doGet(this.urlProvider.getConfig(), Config.class).getParameter();
    }

    @Override
    public List<Parameter> updateConfig(List<Parameter> parameters) throws HttpClientException {
        Config config = new Config();
        config.getParameter().addAll(parameters);
        return this.getHttpRequestExecutor().doPost(this.urlProvider.getConfig(), config, Config.class).getParameter();
    }

    @Override
    public Parameter getConfigParameter(String parameterId) throws HttpClientException {
        return null;
    }

    @Override
    public List<Action> getActions() throws HttpClientException {
        return this.getHttpRequestExecutor().doGet(this.urlProvider.getActions(), Actions.class).getAction();
    }

    @Override
    public Action getAction(String actionId) throws HttpClientException {
        return null;
    }

    @Override
    public void executeAction(String actionId) throws HttpClientException {
        this.getHttpRequestExecutor().doPost(this.urlProvider.getAction(actionId));
    }

    @Override
    public List<Task> getRoadmap() throws HttpClientException {
        return null;
    }

    @Override
    public Task getRoadmapTask(String taskId) throws HttpClientException {
        return null;
    }

    @Override
    public Error getRoadmaprTaskError(String taskId) throws HttpClientException {
        return null;
    }

    @Override
    public List<Log> getRoadmapTaskLogs(String taskId) throws HttpClientException {
        return null;
    }

    @Override
    public List<Log> getLogs() throws HttpClientException {
        return this.getHttpRequestExecutor().doGet(this.urlProvider.getLogs(), Logs.class).getLog();
    }

    @Override
    public Log getLog(String logId) throws HttpClientException {
        return this.getHttpRequestExecutor().doGet(this.urlProvider.getLog(logId), Log.class);
    }

    @Override
    public String getLogContent(String contentUrl) throws HttpClientException {
        return this.getHttpRequestExecutor().doGet(this.urlProvider.getLogContent(contentUrl), String.class);
    }

    @Override
    public Error getError() throws HttpClientException {
        return this.getHttpRequestExecutor().doGet(this.urlProvider.getError(), Error.class);
    }

    @Override
    public List<Dialog> getDialogs() throws HttpClientException {
        return null;
    }

    @Override
    public Dialog getDialog(String dialogId) throws HttpClientException {
        return null;
    }

    @Override
    public List<ComponentVersion> getVersions() throws HttpClientException {
        return null;
    }

    @Override
    public ComponentVersion getVersion(String versionId) throws HttpClientException {
        return null;
    }

    @Override
    public List<Breakpoint> getBreakpoints() throws HttpClientException {
        return null;
    }

    @Override
    public Breakpoint getBreapoint(String breakpointId) throws HttpClientException {
        return null;
    }

    @Override
    public List<Breakpoint> getCurrentBreakpoints() throws HttpClientException {
        return null;
    }

    @Override
    public Breakpoint getCurrentBreapoint(String breakpointId) throws HttpClientException {
        return null;
    }

    @Override
    public List<Property> getProperties() throws HttpClientException {
        return null;
    }

    @Override
    public Property getProperty(String propertyId) throws HttpClientException {
        return null;
    }
}

