/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.lm.sl.slp.client.communication;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class CsrfHttpClient
implements HttpClient,
Closeable {
    public static final String CSRF_TOKEN_HEADER_NAME = "X-CSRF-TOKEN";
    public static final String CSRF_TOKEN_HEADER_FETCH_VALUE = "Fetch";
    public static final String CSRF_TOKEN_HEADER_REQUIRED_VALUE = "Required";
    public static final String[] DEFAULT_NON_PROTECTED_METHODS = new String[]{"GET", "OPTIONS", "HEAD"};
    private HttpClient httpClient;
    private String csrfToken = null;
    private String csrfGetTokenUrl = null;
    private HashSet<String> nonProtectedMethods;
    private boolean isTokenInitialized;

    public CsrfHttpClient(HttpClient httpClient, String csrfGetTokenUrl) {
        this.httpClient = httpClient;
        this.csrfGetTokenUrl = csrfGetTokenUrl;
        this.nonProtectedMethods = new HashSet<String>(Arrays.asList(DEFAULT_NON_PROTECTED_METHODS));
    }

    public HttpParams getParams() {
        return this.httpClient.getParams();
    }

    public ClientConnectionManager getConnectionManager() {
        return this.httpClient.getConnectionManager();
    }

    public HttpResponse execute(HttpUriRequest request) throws IOException, ClientProtocolException {
        this.setCrsfToken((HttpRequest)request);
        HttpResponse response = this.httpClient.execute(request);
        if (this.isRetryNeeded((HttpRequest)request, response)) {
            this.setCrsfToken((HttpRequest)request);
            response = this.httpClient.execute(request);
        }
        return response;
    }

    public HttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException, ClientProtocolException {
        this.setCrsfToken((HttpRequest)request);
        HttpResponse response = this.httpClient.execute(request, context);
        if (this.isRetryNeeded((HttpRequest)request, response)) {
            this.setCrsfToken((HttpRequest)request);
            response = this.httpClient.execute(request, context);
        }
        return response;
    }

    public HttpResponse execute(HttpHost target, HttpRequest request) throws IOException, ClientProtocolException {
        this.setCrsfToken(request);
        HttpResponse response = this.httpClient.execute(target, request);
        if (this.isRetryNeeded(request, response)) {
            this.setCrsfToken(request);
            response = this.httpClient.execute(target, request);
        }
        return response;
    }

    public HttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        this.setCrsfToken(request);
        HttpResponse response = this.httpClient.execute(target, request, context);
        if (this.isRetryNeeded(request, response)) {
            this.setCrsfToken(request);
            response = this.httpClient.execute(target, request, context);
        }
        return response;
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        this.setCrsfToken((HttpRequest)request);
        return (T)this.httpClient.execute(request, responseHandler);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        this.setCrsfToken((HttpRequest)request);
        return (T)this.httpClient.execute(request, responseHandler, context);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        this.setCrsfToken(request);
        return (T)this.httpClient.execute(target, request, responseHandler);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        this.setCrsfToken(request);
        return (T)this.httpClient.execute(target, request, responseHandler, context);
    }

    public void setNonProtectedMethods(String ... methods) {
        this.nonProtectedMethods.clear();
        if (methods != null) {
            this.nonProtectedMethods.addAll(Arrays.asList(methods));
        }
    }

    private void setCrsfToken(HttpRequest request) throws IOException {
        if (request == null || !this.isProtectionRequired(request)) {
            return;
        }
        this.initializeToken(false);
        if (this.csrfToken != null) {
            request.setHeader(CSRF_TOKEN_HEADER_NAME, this.csrfToken);
        }
    }

    private boolean isProtectionRequired(HttpRequest request) {
        return !this.nonProtectedMethods.contains(request.getRequestLine().getMethod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeToken(boolean force) throws IOException {
        CsrfHttpClient csrfHttpClient = this;
        synchronized (csrfHttpClient) {
            if (force || !this.isTokenInitialized) {
                this.csrfToken = this.fetchNewCsrfToken();
                this.isTokenInitialized = true;
            }
        }
    }

    private String fetchNewCsrfToken() throws IOException {
        if (this.csrfGetTokenUrl == null) {
            return null;
        }
        HttpGet fetchTokenRequest = new HttpGet(this.csrfGetTokenUrl);
        fetchTokenRequest.addHeader(CSRF_TOKEN_HEADER_NAME, CSRF_TOKEN_HEADER_FETCH_VALUE);
        HttpResponse response = this.httpClient.execute((HttpUriRequest)fetchTokenRequest);
        EntityUtils.consume((HttpEntity)response.getEntity());
        if (response.containsHeader(CSRF_TOKEN_HEADER_NAME)) {
            return response.getFirstHeader(CSRF_TOKEN_HEADER_NAME).getValue();
        }
        return null;
    }

    private boolean isRetryNeeded(HttpRequest request, HttpResponse response) throws IOException {
        Header csrfTokenHeader;
        if (!this.isProtectionRequired(request)) {
            return false;
        }
        if (this.isTokenInitialized && response.getStatusLine().getStatusCode() == 403 && (csrfTokenHeader = response.getFirstHeader(CSRF_TOKEN_HEADER_NAME)) != null && CSRF_TOKEN_HEADER_REQUIRED_VALUE.equals(csrfTokenHeader.getValue())) {
            EntityUtils.consume((HttpEntity)response.getEntity());
            this.initializeToken(true);
            return this.csrfToken != null;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this.httpClient instanceof Closeable) {
            ((Closeable)this.httpClient).close();
        }
    }
}

